/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.WriteThread;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.awt.EventQueue;
import java.util.Map;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransactionGuardImpl
extends TransactionGuard {
    private static final Logger LOG = Logger.getInstance(TransactionGuardImpl.class);
    private final Map<ModalityState, Boolean> myWriteSafeModalities = ContainerUtil.createConcurrentWeakMap();
    private boolean myWritingAllowed;
    private boolean myErrorReported;

    public TransactionGuardImpl() {
        this.myWriteSafeModalities.put(ModalityState.NON_MODAL, true);
        this.myWritingAllowed = SwingUtilities.isEventDispatchThread();
    }

    public void submitTransaction(@NotNull Disposable parentDisposable, @Nullable TransactionId expectedContext, @NotNull Runnable transaction) {
        ModalityState modality = expectedContext == null ? ModalityState.NON_MODAL : ((TransactionIdImpl)expectedContext).myModality;
        Application app = ApplicationManager.getApplication();
        if (app.isWriteThread() && this.myWritingAllowed && !ModalityState.current().dominates(modality)) {
            if (!Disposer.isDisposed((Disposable)parentDisposable)) {
                transaction.run();
            }
        } else {
            ((AppUIExecutor)AppUIExecutor.onWriteThread((ModalityState)modality).later().expireWith(parentDisposable)).submit(transaction);
        }
    }

    public void submitTransactionAndWait(@NotNull Runnable runnable2) throws ProcessCanceledException {
        Application app = ApplicationManager.getApplication();
        if (app.isWriteThread()) {
            if (!this.myWritingAllowed) {
                String message = "Cannot run synchronous submitTransactionAndWait from invokeLater. Please use asynchronous submit*Transaction. See TransactionGuard FAQ for details.\nTransaction: " + runnable2;
                if (!this.isWriteSafeModality(ModalityState.current())) {
                    message = message + "\nUnsafe modality: " + ModalityState.current();
                }
                LOG.error(message);
            }
            runnable2.run();
            return;
        }
        if (app.isReadAccessAllowed()) {
            throw new IllegalStateException("submitTransactionAndWait should not be invoked from a read action");
        }
        ModalityState state = ModalityState.defaultModalityState();
        if (!this.isWriteSafeModality(state)) {
            LOG.error("Cannot run synchronous submitTransactionAndWait from a background thread created in a write-unsafe context");
        }
        WriteThread.invokeAndWait((Runnable)runnable2);
    }

    public void performUserActivity(Runnable activity) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        AccessToken token = this.startActivity(true);
        try {
            activity.run();
        }
        finally {
            token.finish();
        }
    }

    @NotNull
    public AccessToken startActivity(boolean userActivity) {
        boolean allowWriting;
        this.myErrorReported = false;
        boolean bl = allowWriting = userActivity && this.isWriteSafeModality(ModalityState.current());
        if (this.myWritingAllowed == allowWriting) {
            return AccessToken.EMPTY_ACCESS_TOKEN;
        }
        if (allowWriting) {
            ApplicationManager.getApplication().assertIsWriteThread();
        } else if (!EventQueue.isDispatchThread()) {
            LOG.error("must be swing thread");
        }
        final boolean prev = this.myWritingAllowed;
        this.myWritingAllowed = allowWriting;
        return new AccessToken(){

            public void finish() {
                TransactionGuardImpl.this.myWritingAllowed = prev;
            }
        };
    }

    public boolean isWritingAllowed() {
        ApplicationManager.getApplication().assertIsWriteThread();
        return this.myWritingAllowed;
    }

    public boolean isWriteSafeModality(ModalityState state) {
        return Boolean.TRUE.equals(this.myWriteSafeModalities.get(state));
    }

    public void assertWriteActionAllowed() {
        ApplicationManager.getApplication().assertIsWriteThread();
        if (!this.myWritingAllowed && TransactionGuardImpl.areAssertionsEnabled() && !this.myErrorReported) {
            LOG.error(TransactionGuardImpl.reportWriteUnsafeContext(ModalityState.current()));
            this.myErrorReported = true;
        }
    }

    private static String reportWriteUnsafeContext(@NotNull ModalityState modality) {
        return "Write-unsafe context! Model changes are allowed from write-safe contexts only. Please ensure you're using invokeLater/invokeAndWait with a correct modality state (not \"any\"). See TransactionGuard documentation for details.\n  current modality=" + modality;
    }

    public void assertWriteSafeContext(@NotNull ModalityState modality) {
        if (!this.isWriteSafeModality(modality) && TransactionGuardImpl.areAssertionsEnabled()) {
            LOG.error(TransactionGuardImpl.reportWriteUnsafeContext(modality));
        }
    }

    private static boolean areAssertionsEnabled() {
        return LoadingState.COMPONENTS_LOADED.isOccurred() && Registry.is((String)"ide.require.transaction.for.model.changes", (boolean)false);
    }

    public void submitTransactionLater(@NotNull Disposable parentDisposable, @NotNull Runnable transaction) {
        TransactionIdImpl ctx = this.getContextTransaction();
        ApplicationManager.getApplication().invokeLaterOnWriteThread(transaction, ctx == null ? ModalityState.NON_MODAL : ctx.myModality);
    }

    public TransactionIdImpl getContextTransaction() {
        if (ApplicationManager.getApplication().isWriteThread() ? !this.myWritingAllowed : ProgressIndicatorProvider.getGlobalProgressIndicator() == null) {
            return null;
        }
        ModalityState state = ModalityState.defaultModalityState();
        return this.isWriteSafeModality(state) ? new TransactionIdImpl(state) : null;
    }

    public void enteredModality(@NotNull ModalityState modality) {
        this.myWriteSafeModalities.put(modality, this.myWritingAllowed);
    }

    @NotNull
    public Runnable wrapLaterInvocation(final @NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (this.isWriteSafeModality(modalityState)) {
            return new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().assertIsWriteThread();
                    boolean prev = TransactionGuardImpl.this.myWritingAllowed;
                    TransactionGuardImpl.this.myWritingAllowed = true;
                    try {
                        runnable2.run();
                    }
                    finally {
                        TransactionGuardImpl.this.myWritingAllowed = prev;
                    }
                }

                public String toString() {
                    return runnable2.toString();
                }
            };
        }
        return runnable2;
    }

    public String toString() {
        return "TransactionGuardImpl{myWritingAllowed=" + this.myWritingAllowed + '}';
    }

    private static class TransactionIdImpl
    implements TransactionId {
        final ModalityState myModality;

        private TransactionIdImpl(ModalityState modality) {
            this.myModality = modality;
        }

        public String toString() {
            return this.myModality.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionIdImpl)) {
                return false;
            }
            TransactionIdImpl id2 = (TransactionIdImpl)o;
            return Objects.equals(this.myModality, id2.myModality);
        }

        public int hashCode() {
            return Objects.hash(this.myModality);
        }
    }
}

