/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.application.options.RegistryManager;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Preloader
implements ApplicationInitializedListener {
    private static final ExtensionPointName<PreloadingActivity> EP_NAME = new ExtensionPointName("com.intellij.preloadingActivity");
    private static final Logger LOG = Logger.getInstance(Preloader.class);

    Preloader() {
    }

    private static void checkHeavyProcessRunning() {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            TimeoutUtil.sleep((long)1L);
        }
    }

    public void componentsInitialized() {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isHeadlessEnvironment() || !RegistryManager.getInstance().is("enable.activity.preloading")) {
            return;
        }
        EP_NAME.processWithPluginDescriptor(Preloader::preload);
    }

    private static void preload(@NotNull PreloadingActivity activity, @Nullable PluginDescriptor descriptor2) {
        ExecutorService executor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Preloader Pool", (int)1);
        final ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        Disposer.register((Disposable)ApplicationManager.getApplication(), () -> ((ProgressIndicator)indicator).cancel());
        AbstractProgressIndicatorBase wrappingIndicator = new AbstractProgressIndicatorBase(){

            @Override
            public void checkCanceled() {
                Preloader.checkHeavyProcessRunning();
                indicator.checkCanceled();
            }

            @Override
            public boolean isCanceled() {
                return indicator.isCanceled();
            }
        };
        executor.execute(() -> {
            if (indicator.isCanceled()) {
                return;
            }
            Preloader.checkHeavyProcessRunning();
            if (indicator.isCanceled()) {
                return;
            }
            ProgressManager.getInstance().runProcess(() -> {
                Activity measureActivity = descriptor2 == null ? null : StartUpMeasurer.startActivity((String)activity.getClass().getName(), (ActivityCategory)ActivityCategory.PRELOAD_ACTIVITY, (String)descriptor2.getPluginId().getIdString());
                try {
                    activity.preload(wrappingIndicator);
                }
                catch (ProcessCanceledException ignore) {
                    return;
                }
                finally {
                    if (measureActivity != null) {
                        measureActivity.end();
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(activity.getClass().getName() + " finished");
                }
            }, indicator);
        });
    }
}

