/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.ide.CliResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationStarterBase
implements ApplicationStarter {
    private final String myCommandName;
    private final int[] myArgsCount;

    protected ApplicationStarterBase(@NotNull String commandName, int ... possibleArgumentsCount) {
        this.myCommandName = commandName;
        this.myArgsCount = possibleArgumentsCount;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public boolean isHeadless() {
        return false;
    }

    public boolean canProcessExternalCommandLine() {
        return true;
    }

    @NotNull
    public Future<CliResult> processExternalCommandLineAsync(@NotNull List<String> args, @Nullable String currentDirectory) {
        if (!this.checkArguments(args)) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((String)this.getUsageMessage(), (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getInformationIcon()));
            return CliResult.error((int)1, (String)this.getUsageMessage());
        }
        try {
            return this.processCommand(args, currentDirectory);
        }
        catch (Exception e) {
            String message = String.format("Error executing %s: %s", this.getCommandName(), e.getMessage());
            ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((String)message, (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getErrorIcon()));
            return CliResult.error((int)1, (String)message);
        }
    }

    protected static void saveAll() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().saveSettings();
    }

    protected static void saveIfNeeded(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
    }

    private boolean checkArguments(@NotNull List<String> args) {
        return Arrays.binarySearch(this.myArgsCount, args.size() - 1) != -1 && this.getCommandName().equals(args.get(0));
    }

    public abstract @NlsContexts.DialogMessage String getUsageMessage();

    @NotNull
    protected abstract Future<CliResult> processCommand(@NotNull List<String> var1, @Nullable String var2) throws Exception;

    public void premain(@NotNull List<String> args) {
        if (!this.checkArguments(args)) {
            System.err.println(this.getUsageMessage());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main(@NotNull List<String> args) {
        try {
            int exitCode;
            try {
                Future<CliResult> commandFuture = this.processCommand(args, null);
                CliResult result2 = commandFuture.get();
                if (result2.message != null) {
                    System.out.println(result2.message);
                }
                exitCode = result2.exitCode;
            }
            finally {
                ApplicationManager.getApplication().invokeAndWait(ApplicationStarterBase::saveAll);
            }
            System.exit(exitCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(2);
        }
    }
}

