/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.impl.MacGestureAdapter;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import gnu.trove.THashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

@Service
public final class MouseGestureManager {
    private static final Logger LOG = Logger.getInstance((String)"MouseGestureManager");
    private final Map<IdeFrame, Object> myListeners = new THashMap();
    private boolean hasTrackPad = false;

    public static MouseGestureManager getInstance() {
        return (MouseGestureManager)ServiceManager.getService(MouseGestureManager.class);
    }

    public void add(@NotNull IdeFrame frame) {
        if (!SystemInfo.isMacOSSnowLeopard || !Registry.is((String)"actionSystem.mouseGesturesEnabled")) {
            return;
        }
        try {
            if (this.myListeners.containsKey(frame)) {
                this.remove(frame);
            }
            this.myListeners.put(frame, (Object)new MacGestureAdapter(this, frame));
        }
        catch (Throwable e) {
            LOG.error("Can't initialize MacGestureAdapter", e);
        }
    }

    void activateTrackpad() {
        this.hasTrackPad = true;
    }

    public boolean hasTrackpad() {
        return this.hasTrackPad;
    }

    public void remove(@NotNull IdeFrame frame) {
        if (!SystemInfo.isMacOSSnowLeopard || !Registry.is((String)"actionSystem.mouseGesturesEnabled")) {
            return;
        }
        try {
            Object listener2 = this.myListeners.get(frame);
            JComponent cmp = frame.getComponent();
            this.myListeners.remove(frame);
            if (listener2 != null && cmp != null && cmp.isShowing()) {
                ((MacGestureAdapter)((Object)listener2)).remove(cmp);
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }
}

