/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionPopupMenuImpl
implements ActionPopupMenu,
ApplicationActivationListener {
    private static final Logger LOG = Logger.getInstance(ActionPopupMenuImpl.class);
    private final Application myApp;
    private final MyMenu myMenu;
    private final ActionManagerImpl myManager;
    private Getter<? extends DataContext> myDataContextProvider;
    private MessageBusConnection myConnection;
    private IdeFrame myFrame;
    private boolean myIsToolWindowContextMenu;

    ActionPopupMenuImpl(@NotNull String place, @NotNull ActionGroup group, @NotNull ActionManagerImpl actionManager, @Nullable PresentationFactory factory2) {
        this.myManager = actionManager;
        this.myMenu = new MyMenu(place, group, factory2);
        this.myApp = ApplicationManager.getApplication();
    }

    @NotNull
    public JPopupMenu getComponent() {
        return this.myMenu;
    }

    @NotNull
    public String getPlace() {
        return this.myMenu.myPlace;
    }

    @NotNull
    public ActionGroup getActionGroup() {
        return this.myMenu.myGroup;
    }

    void setDataContextProvider(@NotNull Getter<? extends DataContext> dataContextProvider) {
        this.myDataContextProvider = dataContextProvider;
    }

    public void setTargetComponent(@NotNull JComponent component2) {
        this.myDataContextProvider = () -> DataManager.getInstance().getDataContext((Component)component2);
        this.myIsToolWindowContextMenu = ComponentUtil.getParentOfType(InternalDecorator.class, (Component)component2) != null;
    }

    boolean isToolWindowContextMenu() {
        return this.myIsToolWindowContextMenu;
    }

    public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
        if (this.myFrame == ideFrame) {
            this.myMenu.setVisible(false);
        }
    }

    private class MyMenu
    extends JBPopupMenu {
        @NotNull
        private final String myPlace;
        @NotNull
        private final ActionGroup myGroup;
        private DataContext myContext;
        private final PresentationFactory myPresentationFactory;

        MyMenu(@NotNull String place, @Nullable ActionGroup group, PresentationFactory factory2) {
            this.myPlace = place;
            this.myGroup = group;
            this.myPresentationFactory = factory2 != null ? factory2 : new MenuItemPresentationFactory();
            this.addPopupMenuListener(new MyPopupMenuListener());
            UiInspectorUtil.registerProvider((JComponent)((Object)this), () -> UiInspectorUtil.collectActionGroupInfo("Menu", this.myGroup, this.myPlace));
        }

        public void show(@NotNull Component component2, int x, int y) {
            if (!component2.isShowing()) {
                throw new IllegalArgumentException("component must be shown on the screen (" + component2 + ")");
            }
            this.removeAll();
            int x2 = Math.max(0, Math.min(x, component2.getWidth() - 1));
            int y2 = Math.max(0, Math.min(y, component2.getHeight() - 1));
            this.myContext = ActionPopupMenuImpl.this.myDataContextProvider != null ? (DataContext)ActionPopupMenuImpl.this.myDataContextProvider.get() : DataManager.getInstance().getDataContext(component2, x2, y2);
            long time = -System.currentTimeMillis();
            Utils.fillMenu(this.myGroup, (JComponent)((Object)this), !UISettings.getInstance().getDisableMnemonics(), this.myPresentationFactory, this.myContext, this.myPlace, false, LaterInvocator.isInModalContext(), false);
            if ((time += System.currentTimeMillis()) > 1000L) {
                LOG.warn(time + "ms to fill popup menu " + this.myPlace);
            }
            if (this.getComponentCount() == 0) {
                LOG.warn("no components in popup menu " + this.myPlace);
                return;
            }
            if (ActionPopupMenuImpl.this.myApp != null && ActionPopupMenuImpl.this.myApp.isActive()) {
                Component frame = ComponentUtil.findUltimateParent((Component)component2);
                if (frame instanceof IdeFrame) {
                    ActionPopupMenuImpl.this.myFrame = (IdeFrame)frame;
                }
                ActionPopupMenuImpl.this.myConnection = ActionPopupMenuImpl.this.myApp.getMessageBus().connect();
                ActionPopupMenuImpl.this.myConnection.subscribe(ApplicationActivationListener.TOPIC, (Object)ActionPopupMenuImpl.this);
            }
            assert (component2.isShowing()) : "Component: " + component2;
            super.show(component2, x, y);
        }

        public void setVisible(boolean b) {
            super.setVisible(b);
            if (!b) {
                ReflectionUtil.resetField((Object)((Object)this), (String)"invoker");
            }
        }

        private class MyPopupMenuListener
        implements PopupMenuListener {
            private MyPopupMenuListener() {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.disposeMenu();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.disposeMenu();
            }

            private void disposeMenu() {
                ActionPopupMenuImpl.this.myManager.removeActionPopup(ActionPopupMenuImpl.this);
                MyMenu.this.removeAll();
                if (ActionPopupMenuImpl.this.myConnection != null) {
                    ActionPopupMenuImpl.this.myConnection.disconnect();
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MyMenu.this.removeAll();
                Utils.fillMenu(MyMenu.this.myGroup, (JComponent)((Object)MyMenu.this), !UISettings.getInstance().getDisableMnemonics(), MyMenu.this.myPresentationFactory, MyMenu.this.myContext, MyMenu.this.myPlace, false, LaterInvocator.isInModalContext(), false);
                ActionPopupMenuImpl.this.myManager.addActionPopup(ActionPopupMenuImpl.this);
            }
        }
    }
}

