/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.impl.NotificationAllowlistEP;
import com.intellij.notification.impl.NotificationWhitelistEP;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationCollector {
    private static final Logger LOG = Logger.getInstance(NotificationCollector.class);
    private static final Map<String, PluginInfo> ourNotificationGroupsWhitelist = new ConcurrentHashMap<String, PluginInfo>();
    private static final Set<String> ourNotificationsWhitelist = new HashSet<String>();
    private static final String NOTIFICATIONS = "notifications";
    private static final String UNKNOWN = "unknown";
    private static final String NOTIFICATION_GROUP = "notification_group";

    private NotificationCollector() {
        ContainerUtil.concat((List)NotificationWhitelistEP.EP_NAME.getExtensionList(), (List)NotificationAllowlistEP.EP_NAME.getExtensionList()).forEach(NotificationCollector::addNotificationsToWhitelist);
        ExtensionPointListener<NotificationAllowlistEP> extensionPointListener = new ExtensionPointListener<NotificationAllowlistEP>(){

            public void extensionAdded(@NotNull NotificationAllowlistEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                NotificationCollector.addNotificationsToWhitelist(extension);
            }

            public void extensionRemoved(@NotNull NotificationAllowlistEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                NotificationCollector.removeNotificationsFromWhitelist(extension);
            }
        };
        NotificationWhitelistEP.EP_NAME.addExtensionPointListener((ExtensionPointListener)extensionPointListener, (Disposable)ApplicationManager.getApplication());
        NotificationAllowlistEP.EP_NAME.addExtensionPointListener((ExtensionPointListener)extensionPointListener, (Disposable)ApplicationManager.getApplication());
    }

    public void logBalloonShown(@Nullable Project project, @NotNull NotificationDisplayType displayType, @NotNull Notification notification, boolean isExpandable) {
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId).addData("display_type", displayType.name()).addData("severity", notification.getType().name()).addData("is_expandable", isExpandable);
        FUCounterUsageLogger.getInstance().logEvent(project, NOTIFICATIONS, "shown", data2);
    }

    public void logToolWindowNotificationShown(@Nullable Project project, @NotNull Notification notification) {
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId).addData("display_type", NotificationDisplayType.TOOL_WINDOW.name()).addData("severity", notification.getType().name());
        FUCounterUsageLogger.getInstance().logEvent(project, NOTIFICATIONS, "shown", data2);
    }

    public void logNotificationLoggedInEventLog(@NotNull Project project, @NotNull Notification notification) {
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId).addData("severity", notification.getType().name());
        FUCounterUsageLogger.getInstance().logEvent(project, NOTIFICATIONS, "logged", data2);
    }

    public void logNotificationBalloonClosedByUser(@Nullable String notificationId, @Nullable String notificationDisplayId, @Nullable String groupId2) {
        if (notificationId == null) {
            return;
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(groupId2, notificationId, notificationDisplayId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "closed.by.user", data2);
    }

    public void logNotificationActionInvoked(@NotNull Notification notification, @NotNull AnAction action2, @NotNull NotificationPlace notificationPlace) {
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId).addData("notification_place", notificationPlace.name());
        if (action2 instanceof NotificationAction.Simple) {
            Object actionInstance = ((NotificationAction.Simple)action2).getActionInstance();
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo(actionInstance.getClass());
            data2.addData("action_id", info.isSafeToReport() ? actionInstance.getClass().getName() : "third.party");
        } else {
            ActionsCollectorImpl.addActionClass(data2, action2, PluginInfoDetectorKt.getPluginInfo(action2.getClass()));
        }
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "action.invoked", data2);
    }

    public void logHyperlinkClicked(@NotNull Notification notification) {
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "hyperlink.clicked", data2);
    }

    public void logBalloonShownFromEventLog(@NotNull Notification notification) {
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "event.log.balloon.shown", data2);
    }

    public void logNotificationSettingsClicked(@NotNull String notificationId, @Nullable String notificationDisplayId, @Nullable String groupId2) {
        FeatureUsageData data2 = NotificationCollector.createNotificationData(groupId2, notificationId, notificationDisplayId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "settings.clicked", data2);
    }

    public void logNotificationBalloonExpanded(@NotNull Notification notification) {
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "balloon.expanded", data2);
    }

    public void logNotificationBalloonCollapsed(@NotNull Notification notification) {
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "balloon.collapsed", data2);
    }

    @NotNull
    private static FeatureUsageData createNotificationData(@Nullable String groupId2, @NotNull String id2, @Nullable String displayId) {
        return new FeatureUsageData().addData("id", id2).addData("display_id", StringUtil.isNotEmpty((String)displayId) ? displayId : UNKNOWN).addData(NOTIFICATION_GROUP, StringUtil.isNotEmpty((String)groupId2) ? groupId2 : UNKNOWN).addPluginInfo(NotificationCollector.getPluginInfo(groupId2));
    }

    public static NotificationCollector getInstance() {
        return (NotificationCollector)ServiceManager.getService(NotificationCollector.class);
    }

    private static void removeNotificationsFromWhitelist(@NotNull NotificationAllowlistEP extension) {
        PluginDescriptor pluginDescriptor = extension.getPluginDescriptor();
        if (pluginDescriptor == null) {
            return;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor);
        if (!info.isDevelopedByJetBrains()) {
            return;
        }
        List<String> notificationGroups = NotificationCollector.parseIds(extension.groupIds);
        for (String notificationGroup : notificationGroups) {
            ourNotificationGroupsWhitelist.remove(notificationGroup, info);
        }
    }

    private static PluginInfo getPluginInfo(@Nullable String groupId2) {
        if (groupId2 == null) {
            return null;
        }
        PluginInfo pluginInfo = ourNotificationGroupsWhitelist.get(groupId2);
        if (pluginInfo != null) {
            return pluginInfo;
        }
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId2);
        if (group == null) {
            return null;
        }
        return PluginInfoDetectorKt.getPluginInfoById((PluginId)group.getPluginId());
    }

    private static void addNotificationsToWhitelist(@NotNull NotificationAllowlistEP extension) {
        PluginDescriptor pluginDescriptor = extension.getPluginDescriptor();
        if (pluginDescriptor == null) {
            return;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor);
        if (!info.isDevelopedByJetBrains()) {
            return;
        }
        List<String> notificationGroups = NotificationCollector.parseIds(extension.groupIds);
        for (String notificationGroup : notificationGroups) {
            ourNotificationGroupsWhitelist.merge(notificationGroup, info, (oldValue, newValue2) -> {
                if (!oldValue.equals(newValue2)) {
                    LOG.warn("Notification group '" + notificationGroup + "' is already registered in whitelist");
                    return PluginInfoDetectorKt.getUnknownPlugin();
                }
                return oldValue;
            });
        }
        ourNotificationsWhitelist.addAll(NotificationCollector.parseIds(extension.notificationIds));
    }

    @NotNull
    private static List<String> parseIds(@Nullable String entry) {
        String[] values2;
        if (entry == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list2 = new ArrayList<String>();
        for (String value2 : values2 = StringUtil.convertLineSeparators((String)entry, (String)"").split(";")) {
            if (StringUtil.isEmptyOrSpaces((String)value2)) continue;
            list2.add(StringUtil.trim((String)value2));
        }
        return list2;
    }

    public static enum NotificationPlace {
        BALLOON,
        EVENT_LOG;

    }

    public static class NotificationIdValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "notification_display_id".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (NotificationCollector.UNKNOWN.equals(data2)) {
                return ValidationResultType.ACCEPTED;
            }
            return ourNotificationsWhitelist.contains(data2) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
        }
    }

    public static class NotificationGroupValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return NotificationCollector.NOTIFICATION_GROUP.equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (NotificationCollector.UNKNOWN.equals(data2)) {
                return ValidationResultType.ACCEPTED;
            }
            return ourNotificationGroupsWhitelist.containsKey(data2) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
        }
    }
}

