/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.impl.MessageBusFactoryImpl;
import com.intellij.util.pico.DefaultPicoContainer;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class MockComponentManager
extends UserDataHolderBase
implements ComponentManager,
MessageBusOwner {
    private final MessageBus myMessageBus = MessageBusFactoryImpl.createRootBus((MessageBusOwner)this);
    private final DefaultPicoContainer myPicoContainer;
    private final ExtensionsAreaImpl myExtensionArea;
    private final Map<Class<?>, Object> myComponents = new THashMap();
    private final Set<Object> myDisposableComponents = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean myDisposed;

    public MockComponentManager(@Nullable PicoContainer parent, @NotNull Disposable parentDisposable) {
        this.myPicoContainer = new DefaultPicoContainer((DefaultPicoContainer)parent){

            @Nullable
            public Object getComponentInstance(@NotNull Object componentKey) {
                if (MockComponentManager.this.myDisposed) {
                    throw new IllegalStateException("Cannot get " + componentKey + " from already disposed " + (Object)((Object)this));
                }
                Object o = super.getComponentInstance(componentKey);
                MockComponentManager.this.registerComponentInDisposer(o);
                return o;
            }
        };
        this.myPicoContainer.registerComponentInstance((Object)this);
        this.myExtensionArea = new ExtensionsAreaImpl((ComponentManager)this);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @NotNull
    public ExtensionsAreaImpl getExtensionArea() {
        return this.myExtensionArea;
    }

    protected void registerComponentInDisposer(@Nullable Object o) {
        if (o instanceof Disposable && o != this && !(o instanceof MessageBus) && this.myDisposableComponents.add(o)) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)o));
        }
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull Class<? extends T> serviceImplementation) {
        this.myPicoContainer.unregisterComponent((Object)serviceInterface.getName());
        this.myPicoContainer.registerComponentImplementation((Object)serviceInterface.getName(), serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceImplementation) {
        this.registerService(serviceImplementation, (T)serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        this.myPicoContainer.registerComponentInstance((Object)serviceInterface.getName(), serviceImplementation);
        this.registerComponentInDisposer(serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation, @NotNull Disposable parentDisposable) {
        String key = serviceInterface.getName();
        this.registerService(serviceInterface, serviceImplementation);
        Disposer.register((Disposable)parentDisposable, () -> this.myPicoContainer.unregisterComponent((Object)key));
    }

    public <T> void addComponent(@NotNull Class<T> interfaceClass, @NotNull T instance) {
        this.myComponents.put(interfaceClass, instance);
        this.registerComponentInDisposer(instance);
    }

    @Nullable
    public <T> T getComponent(@NotNull Class<T> interfaceClass) {
        Object o = this.myPicoContainer.getComponentInstance(interfaceClass);
        return (T)(o != null ? o : this.myComponents.get(interfaceClass));
    }

    public <T> T getService(@NotNull Class<T> serviceClass) {
        Object result2 = this.myPicoContainer.getService(serviceClass);
        this.registerComponentInDisposer(result2);
        return (T)result2;
    }

    @NotNull
    public final MutablePicoContainer getPicoContainer() {
        return this.myPicoContainer;
    }

    @NotNull
    public MessageBus getMessageBus() {
        return this.myMessageBus;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myMessageBus);
        this.myDisposed = true;
    }

    @NotNull
    public Condition<?> getDisposed() {
        return Conditions.alwaysFalse();
    }

    @NotNull
    public Object createListener(@NotNull ListenerDescriptor descriptor2) {
        throw new UnsupportedOperationException();
    }
}

