/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.actions;

import com.intellij.icons.AllIcons;
import com.intellij.largeFilesEditor.search.searchResultsPanel.RangeSearch;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.project.DumbAware;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FindFurtherAction
extends AnAction
implements DumbAware {
    private final boolean directionForward;
    private final RangeSearch myRangeSearch;

    public FindFurtherAction(boolean directionForward, RangeSearch rangeSearch) {
        Icon icon2;
        String description;
        String text;
        this.directionForward = directionForward;
        this.myRangeSearch = rangeSearch;
        if (directionForward) {
            text = EditorBundle.message((String)"large.file.editor.find.further.forward.action.text", (Object[])new Object[0]);
            description = EditorBundle.message((String)"large.file.editor.find.further.forward.action.description", (Object[])new Object[0]);
            icon2 = Holder.ICON_FIND_ADD_NEXT;
        } else {
            text = EditorBundle.message((String)"large.file.editor.find.further.backward.action.text", (Object[])new Object[0]);
            description = EditorBundle.message((String)"large.file.editor.find.further.backward.action.description", (Object[])new Object[0]);
            icon2 = Holder.ICON_FIND_ADD_PREV;
        }
        this.getTemplatePresentation().setText(text);
        this.getTemplatePresentation().setDescription(description);
        this.getTemplatePresentation().setIcon(icon2);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled = this.myRangeSearch.isButtonFindFurtherEnabled(this.directionForward);
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.myRangeSearch.onClickSearchFurther(this.directionForward);
    }

    private static class Holder {
        private static final Icon ICON_FIND_ADD_NEXT = AllIcons.Actions.FindAndShowNextMatches;
        private static final Icon ICON_FIND_ADD_PREV = AllIcons.Actions.FindAndShowPrevMatches;

        private Holder() {
        }
    }
}

