/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.cachedValueProfiler;

import com.google.gson.stream.JsonWriter;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.psi.util.ProfilingInfo;
import com.intellij.util.containers.MultiMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedValueProfilerDumper {
    private final MultiMap<StackTraceElement, ProfilingInfo> myStorage;

    private CachedValueProfilerDumper(MultiMap<StackTraceElement, ProfilingInfo> storage) {
        this.myStorage = storage;
    }

    @NotNull
    public static File dumpResults(@Nullable File dir) throws IOException {
        CachedValueProfiler profiler = CachedValueProfiler.getInstance();
        CachedValueProfilerDumper dumper = new CachedValueProfilerDumper((MultiMap<StackTraceElement, ProfilingInfo>)profiler.getStorageSnapshot());
        return dumper.dump(dir);
    }

    @NotNull
    private File dump(@Nullable File dir) throws IOException {
        List<TotalInfo> infos = this.prepareInfo();
        String fileName = String.format("dump-%s.cvp", CachedValueProfilerDumper.time());
        File file2 = new File(dir, fileName);
        try (JsonWriter writer = new JsonWriter((Writer)new BufferedWriter(new FileWriter(file2)));){
            new MyWriter(writer).write(infos);
        }
        return file2;
    }

    @NotNull
    private List<TotalInfo> prepareInfo() {
        ArrayList<TotalInfo> list2 = new ArrayList<TotalInfo>();
        this.myStorage.entrySet().forEach(entry -> list2.add(new TotalInfo((StackTraceElement)entry.getKey(), (Collection)entry.getValue())));
        list2.sort(Comparator.comparing(info -> (double)((TotalInfo)info).getTotalUseCount() / (double)((TotalInfo)info).getInfos().size()));
        return list2;
    }

    @NotNull
    private static String time() {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('|').appendValue(ChronoField.YEAR).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
        return LocalDateTime.now().format(formatter);
    }

    private static class MyWriter {
        private final JsonWriter myWriter;

        private MyWriter(@NotNull JsonWriter writer) {
            this.myWriter = writer;
        }

        private void write(@NotNull List<TotalInfo> infos) throws IOException {
            this.myWriter.setIndent("  ");
            this.myWriter.beginArray();
            for (TotalInfo info : infos) {
                this.writeInfo(info);
            }
            this.myWriter.endArray();
        }

        private void writeInfo(@NotNull TotalInfo info) throws IOException {
            this.myWriter.beginObject();
            String origin = info.getOrigin().toString();
            long totalLifeTime = info.getTotalLifeTime();
            long totalUseCount = info.getTotalUseCount();
            int createdCount = info.getInfos().size();
            this.myWriter.name("origin").value(origin);
            this.myWriter.name("total lifetime").value(totalLifeTime);
            this.myWriter.name("total use count").value(totalUseCount);
            this.myWriter.name("created").value((long)createdCount);
            this.myWriter.endObject();
        }
    }

    private static class TotalInfo {
        private final StackTraceElement myOrigin;
        private final long myTotalLifeTime;
        private final long myTotalUseCount;
        private final List<ProfilingInfo> myInfos;

        private TotalInfo(@NotNull StackTraceElement origin, @NotNull Collection<ProfilingInfo> infos) {
            this.myOrigin = origin;
            this.myInfos = Collections.unmodifiableList(new ArrayList<ProfilingInfo>(infos));
            this.myTotalLifeTime = this.myInfos.stream().mapToLong(value2 -> value2.getLifetime()).sum();
            this.myTotalUseCount = this.myInfos.stream().mapToLong(value2 -> value2.getUseCount()).sum();
        }

        @NotNull
        private StackTraceElement getOrigin() {
            return this.myOrigin;
        }

        private long getTotalLifeTime() {
            return this.myTotalLifeTime;
        }

        private long getTotalUseCount() {
            return this.myTotalUseCount;
        }

        @NotNull
        private List<ProfilingInfo> getInfos() {
            return this.myInfos;
        }
    }
}

