/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class GroupWrapper
extends CachingChildrenTreeNode<Group> {
    private static final Logger LOG = Logger.getInstance(GroupWrapper.class);

    public GroupWrapper(Project project, @NotNull Group value2, @NotNull TreeModel treeModel) {
        super(project, value2, treeModel);
        this.clearChildren();
    }

    @Override
    public void copyFromNewInstance(@NotNull CachingChildrenTreeNode newInstance) {
        this.clearChildren();
        this.setChildren(newInstance.getChildren());
        this.synchronizeChildren();
    }

    public void update(@NotNull PresentationData presentation2) {
        presentation2.updateFrom(((Group)this.getValue()).getPresentation());
    }

    @Override
    public void initChildren() {
        this.clearChildren();
        Group group = (Group)this.getValue();
        Collection children2 = group.getChildren();
        for (TreeElement child2 : children2) {
            if (child2 == null) {
                LOG.error(group + " returned null child: " + children2);
            }
            TreeElementWrapper childNode = this.createChildNode(child2);
            this.addSubElement(childNode);
        }
    }

    @Override
    protected void performTreeActions() {
        this.filterChildren(this.myTreeModel.getFilters());
        this.groupChildren(this.myTreeModel.getGroupers());
        this.sortChildren(this.myTreeModel.getSorters());
    }
}

