/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesComponentImpl
extends PropertiesComponent
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(PropertiesComponentImpl.class);
    private final Map<String, String> myMap = new ConcurrentHashMap<String, String>();
    @NonNls
    private static final String ELEMENT_PROPERTY = "property";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";

    PropertiesComponentImpl() {
    }

    private void doPut(@NotNull String key, @NotNull String value2) {
        String reason = Verifier.checkCharacterData((String)key);
        if (reason != null) {
            LOG.error(reason);
        }
        this.myMap.put(key, value2);
        this.incModificationCount();
    }

    public Element getState() {
        Element parentNode = new Element("state");
        ArrayList<String> keys2 = new ArrayList<String>(this.myMap.keySet());
        keys2.sort(null);
        for (String key : keys2) {
            String value2 = this.myMap.get(key);
            if (value2 == null) continue;
            Element element2 = new Element(ELEMENT_PROPERTY);
            element2.setAttribute(ATTRIBUTE_NAME, key);
            element2.setAttribute(ATTRIBUTE_VALUE, value2);
            parentNode.addContent(element2);
        }
        return parentNode;
    }

    public void loadState(@NotNull Element parentNode) {
        this.myMap.clear();
        for (Element e : parentNode.getChildren(ELEMENT_PROPERTY)) {
            String name = e.getAttributeValue(ATTRIBUTE_NAME);
            if (name == null) continue;
            this.myMap.put(name, e.getAttributeValue(ATTRIBUTE_VALUE));
        }
    }

    public String getValue(@NotNull String name) {
        return this.myMap.get(name);
    }

    public void setValue(@NotNull String name, @Nullable String value2) {
        if (value2 == null) {
            this.unsetValue(name);
        } else {
            this.doPut(name, value2);
        }
    }

    public void setValue(@NotNull String name, @Nullable String value2, @Nullable String defaultValue) {
        if (value2 == null || value2.equals(defaultValue)) {
            this.unsetValue(name);
        } else {
            this.doPut(name, value2);
        }
    }

    public void setValue(@NotNull String name, float value2, float defaultValue) {
        if (value2 == defaultValue) {
            this.unsetValue(name);
        } else {
            this.doPut(name, String.valueOf(value2));
        }
    }

    public void setValue(@NotNull String name, int value2, int defaultValue) {
        if (value2 == defaultValue) {
            this.unsetValue(name);
        } else {
            this.doPut(name, String.valueOf(value2));
        }
    }

    public void setValue(@NotNull String name, boolean value2, boolean defaultValue) {
        if (value2 == defaultValue) {
            this.unsetValue(name);
        } else {
            this.setValue(name, String.valueOf(value2));
        }
    }

    public void unsetValue(@NotNull String name) {
        this.myMap.remove(name);
        this.incModificationCount();
    }

    public boolean isValueSet(@NotNull String name) {
        return this.myMap.containsKey(name);
    }

    public String @Nullable [] getValues(@NotNull @NonNls String name) {
        String value2 = this.getValue(name);
        return value2 != null ? value2.split("\n") : null;
    }

    public void setValues(@NotNull @NonNls String name, String[] values2) {
        if (values2 == null) {
            this.setValue(name, null);
        } else {
            this.setValue(name, StringUtil.join((String[])values2, (String)"\n"));
        }
    }
}

