/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DynamicActionGroup;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomisedActionGroup
extends ActionGroup {
    private final ActionGroup myGroup;
    private AnAction[] myChildren;
    private final CustomActionsSchema mySchema;
    private final String myDefaultGroupName;
    private final String myRootGroupName;
    private int mySchemeModificationStamp = -1;
    private int myGroupModificationStamp = -1;

    public CustomisedActionGroup(String shortName, ActionGroup group, CustomActionsSchema schema, String defaultGroupName, String name) {
        this.copyFrom((AnAction)group);
        this.getTemplatePresentation().setText(shortName);
        this.setPopup(group.isPopup());
        this.myGroup = group;
        this.mySchema = schema;
        this.myDefaultGroupName = defaultGroupName;
        this.myRootGroupName = name;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        int currentGroupStamp;
        int currentSchemaStamp = CustomActionsSchema.getInstance().getModificationStamp();
        int n = currentGroupStamp = this.myGroup instanceof DefaultActionGroup ? ((DefaultActionGroup)this.myGroup).getModificationStamp() : -1;
        if (this.mySchemeModificationStamp < currentSchemaStamp || this.myGroupModificationStamp < currentGroupStamp || ArrayUtil.isEmpty((Object[])this.myChildren) || this.myGroup instanceof DynamicActionGroup || !(this.myGroup instanceof DefaultActionGroup)) {
            this.myChildren = CustomizationUtil.getReordableChildren(this.myGroup, this.mySchema, this.myDefaultGroupName, this.myRootGroupName, e);
            this.mySchemeModificationStamp = currentSchemaStamp;
            this.myGroupModificationStamp = currentGroupStamp;
        }
        return this.myChildren;
    }

    public boolean isPopup() {
        return this.myGroup.isPopup();
    }

    public void update(@NotNull AnActionEvent e) {
        this.myGroup.update(e);
    }

    public boolean isDumbAware() {
        return this.myGroup.isDumbAware();
    }

    public boolean canBePerformed(@NotNull DataContext context) {
        return this.myGroup.canBePerformed(context);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.myGroup.actionPerformed(e);
    }

    @Nullable
    public AnAction getFirstAction() {
        AnAction[] children2 = this.getChildren(null);
        return children2.length > 0 ? children2[0] : null;
    }

    public ActionGroup getOrigin() {
        return this.myGroup;
    }

    public void resetChildren() {
        this.myChildren = null;
    }
}

