/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.util.StructureViewCompositeModel;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLanguageStructureViewBuilder
extends TreeBasedStructureViewBuilder {
    private final VirtualFile myVirtualFile;
    private final Project myProject;

    @NotNull
    public static TemplateLanguageStructureViewBuilder create(@NotNull PsiFile psiFile, final @Nullable PairFunction<? super PsiFile, ? super Editor, ? extends StructureViewModel> modelFactory) {
        return new TemplateLanguageStructureViewBuilder((PsiElement)psiFile){

            @Override
            protected TreeBasedStructureViewBuilder createMainBuilder(final @NotNull PsiFile psi) {
                return modelFactory == null ? null : new TreeBasedStructureViewBuilder(){

                    public boolean isRootNodeShown() {
                        return false;
                    }

                    @NotNull
                    public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                        return (StructureViewModel)modelFactory.fun((Object)psi, (Object)editor);
                    }
                };
            }
        };
    }

    protected TemplateLanguageStructureViewBuilder(PsiElement psiElement) {
        this.myProject = psiElement.getProject();
        this.myVirtualFile = psiElement.getContainingFile().getVirtualFile();
    }

    public boolean isRootNodeShown() {
        return false;
    }

    @NotNull
    public StructureView createStructureView(final FileEditor fileEditor, final @NotNull Project project) {
        ArrayList<StructureViewComposite.StructureViewDescriptor> viewDescriptors = new ArrayList<StructureViewComposite.StructureViewDescriptor>();
        VirtualFile file2 = fileEditor == null ? null : fileEditor.getFile();
        PsiFile psiFile = file2 == null || !file2.isValid() ? null : PsiManager.getInstance((Project)project).findFile(file2);
        final List languages = this.getLanguages(psiFile).toList();
        for (Language language : languages) {
            StructureViewBuilder builder2 = this.getBuilder(Objects.requireNonNull(psiFile), language);
            if (builder2 == null) continue;
            StructureView structureView = builder2.createStructureView(fileEditor, project);
            String title = language.getDisplayName();
            Icon icon2 = ((FileType)ObjectUtils.notNull((Object)LanguageUtil.getLanguageFileType((Language)language), (Object)FileTypes.UNKNOWN)).getIcon();
            viewDescriptors.add(new StructureViewComposite.StructureViewDescriptor(title, structureView, icon2));
        }
        StructureViewComposite.StructureViewDescriptor[] array2 = viewDescriptors.toArray(new StructureViewComposite.StructureViewDescriptor[0]);
        return new StructureViewComposite(array2){

            @Override
            public boolean isOutdated() {
                VirtualFile file2 = fileEditor == null ? null : fileEditor.getFile();
                PsiFile psiFile = file2 == null || !file2.isValid() ? null : PsiManager.getInstance((Project)project).findFile(file2);
                List newLanguages = TemplateLanguageStructureViewBuilder.this.getLanguages(psiFile).toList();
                return !Comparing.equal((Object)languages, (Object)newLanguages);
            }
        };
    }

    @NotNull
    public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
        ArrayList<StructureViewComposite.StructureViewDescriptor> viewDescriptors = new ArrayList<StructureViewComposite.StructureViewDescriptor>();
        PsiFile psiFile = Objects.requireNonNull(PsiManager.getInstance((Project)this.myProject).findFile(this.myVirtualFile));
        for (Language language : this.getLanguages(psiFile)) {
            StructureViewBuilder builder2 = this.getBuilder(psiFile, language);
            if (!(builder2 instanceof TreeBasedStructureViewBuilder)) continue;
            StructureViewModel model = ((TreeBasedStructureViewBuilder)builder2).createStructureViewModel(editor);
            String title = language.getDisplayName();
            Icon icon2 = ((FileType)ObjectUtils.notNull((Object)LanguageUtil.getLanguageFileType((Language)language), (Object)FileTypes.UNKNOWN)).getIcon();
            viewDescriptors.add(new StructureViewComposite.StructureViewDescriptor(title, model, icon2));
        }
        return new StructureViewCompositeModel(psiFile, editor, viewDescriptors);
    }

    @NotNull
    private JBIterable<Language> getLanguages(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return JBIterable.empty();
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        Language baseLanguage = viewProvider.getBaseLanguage();
        Language dataLanguage = viewProvider instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage() : null;
        return JBIterable.of((Object)baseLanguage).append((Object)dataLanguage).append((Iterable)viewProvider.getLanguages()).unique().filter(language -> {
            PsiFile psi = viewProvider.getPsi(language);
            return psi != null && (language == baseLanguage || this.isAcceptableBaseLanguageFile(psi));
        });
    }

    @Nullable
    private StructureViewBuilder getBuilder(@NotNull PsiFile psiFile, @NotNull Language language) {
        FileViewProvider viewProvider = psiFile.getViewProvider();
        Language baseLanguage = viewProvider.getBaseLanguage();
        PsiFile psi = viewProvider.getPsi(language);
        if (psi == null) {
            return null;
        }
        if (language == baseLanguage) {
            return this.createMainBuilder(psi);
        }
        PsiStructureViewFactory factory2 = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(language);
        return factory2 == null ? null : factory2.getStructureViewBuilder(psi);
    }

    protected boolean isAcceptableBaseLanguageFile(PsiFile dataFile) {
        return true;
    }

    @Nullable
    protected abstract TreeBasedStructureViewBuilder createMainBuilder(@NotNull PsiFile var1);
}

