/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.script.IdeConsoleScriptBindings;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptEngineManager;
import com.intellij.ide.script.IdeScriptException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IdeStartupScripts
implements ProjectManagerListener {
    private static final Logger LOG = Logger.getInstance(IdeStartupScripts.class);
    private static final String SCRIPT_DIR = "startup";
    private final AtomicBoolean isActive = new AtomicBoolean(true);

    IdeStartupScripts() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    public void projectOpened(@NotNull Project project) {
        if (!this.isActive.compareAndSet(true, false)) {
            return;
        }
        CompletableFuture<List> future2 = CompletableFuture.supplyAsync(IdeStartupScripts::prepareScriptsAndEngines, (Executor)NonUrgentExecutor.getInstance());
        WeakReference<Project> projectRef = new WeakReference<Project>(project);
        StartupManager.getInstance((Project)project).runAfterOpened(() -> future2.thenAcceptAsync(it -> {
            Project project1 = (Project)projectRef.get();
            if (project1 != null) {
                IdeStartupScripts.runAllScriptsImpl(project1, it);
            }
        }, (Executor)NonUrgentExecutor.getInstance()));
    }

    @NotNull
    private static List<Pair<File, IdeScriptEngine>> prepareScriptsAndEngines() {
        List<File> scripts = IdeStartupScripts.getScripts();
        LOG.info(scripts.size() + " startup script(s) found");
        if (scripts.isEmpty()) {
            return Collections.emptyList();
        }
        IdeScriptEngineManager scriptEngineManager = IdeScriptEngineManager.getInstance();
        ArrayList<Pair<File, IdeScriptEngine>> result2 = new ArrayList<Pair<File, IdeScriptEngine>>();
        for (File script : scripts) {
            String extension = FileUtilRt.getExtension((String)script.getName());
            IdeScriptEngine engine = extension.isEmpty() ? null : scriptEngineManager.getEngineByFileExtension(extension, null);
            result2.add((Pair<File, IdeScriptEngine>)Pair.create((Object)script, (Object)engine));
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runImpl(@NotNull Project project, @NotNull File script, @NotNull IdeScriptEngine engine) throws IOException, IdeScriptException {
        String scriptText = FileUtil.loadFile((File)script);
        IdeConsoleScriptBindings.ensureIdeIsBound(project, engine);
        LOG.info(script.getPath());
        long start2 = System.currentTimeMillis();
        try {
            engine.eval(scriptText);
        }
        finally {
            LOG.info("... completed in " + StringUtil.formatDuration((long)(System.currentTimeMillis() - start2)));
        }
    }

    @NotNull
    private static List<File> getScripts() {
        File directory = IdeStartupScripts.getScriptsRootDirectory();
        List scripts = JBIterable.of((Object[])(directory == null ? null : directory.listFiles())).filter(ExtensionsRootType.regularFileFilter()).toList();
        ContainerUtil.sort((List)scripts, (f1, f2) -> {
            String f1Name = f1 != null ? f1.getName() : null;
            String f2Name = f2 != null ? f2.getName() : null;
            return StringUtil.compare((String)f1Name, (String)f2Name, (boolean)false);
        });
        return scripts;
    }

    @Nullable
    private static File getScriptsRootDirectory() {
        try {
            return ExtensionsRootType.getInstance().findResourceDirectory(PluginManagerCore.CORE_ID, SCRIPT_DIR, false);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void runAllScriptsImpl(@NotNull Project project, @NotNull List<Pair<File, IdeScriptEngine>> result2) {
        try {
            for (Pair<File, IdeScriptEngine> pair : result2) {
                try {
                    if (pair.second == null) {
                        LOG.warn(((File)pair.first).getPath() + " not supported (no script engine)");
                        continue;
                    }
                    IdeStartupScripts.runImpl(project, (File)pair.first, (IdeScriptEngine)pair.second);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
        catch (ProcessCanceledException e) {
            LOG.warn("... cancelled");
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }
}

