/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.scratch.ScratchesNamedScope;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    public ScratchTreeStructureProvider(final Project project) {
        ScratchTreeStructureProvider.registerUpdaters(project, (Disposable)project, new Runnable(){
            AbstractProjectViewPane updateTarget;

            @Override
            public void run() {
                if (this.updateTarget == null) {
                    this.updateTarget = ProjectView.getInstance(project).getProjectViewPaneById("ProjectPane");
                }
                if (this.updateTarget != null) {
                    this.updateTarget.updateFromRoot(true);
                }
            }
        });
    }

    private static void registerUpdaters(final @NotNull Project project, final @NotNull Disposable disposable2, final @NotNull Runnable onUpdate) {
        String scratchPath = FileUtil.toSystemIndependentName((String)FileUtil.toCanonicalPath((String)PathManager.getScratchPath()));
        VirtualFileManager.getInstance().addAsyncFileListener(events -> {
            boolean update2 = JBIterable.from((Iterable)events).find(e -> {
                ProgressManager.checkCanceled();
                boolean isDirectory = ScratchTreeStructureProvider.isDirectory(e);
                VirtualFile parent = ScratchTreeStructureProvider.getNewParent(e);
                return parent != null && (ScratchUtil.isScratch(parent) || isDirectory && parent.getPath().startsWith(scratchPath));
            }) != null;
            return !update2 ? null : new AsyncFileListener.ChangeApplier(){

                public void afterVfsChange() {
                    onUpdate.run();
                }
            };
        }, disposable2);
        final ConcurrentMap disposables = ConcurrentFactoryMap.createMap(o -> Disposer.newDisposable((String)o.getDisplayName()));
        for (RootType rootType : RootType.getAllRootTypes()) {
            ScratchTreeStructureProvider.registerRootTypeUpdater(project, rootType, onUpdate, disposable2, disposables);
        }
        RootType.ROOT_EP.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<RootType>(){

            public void extensionAdded(@NotNull RootType rootType, @NotNull PluginDescriptor pluginDescriptor) {
                ScratchTreeStructureProvider.registerRootTypeUpdater(project, rootType, onUpdate, disposable2, disposables);
            }

            public void extensionRemoved(@NotNull RootType rootType, @NotNull PluginDescriptor pluginDescriptor) {
                Disposable rootDisposable = (Disposable)disposables.remove(rootType);
                if (rootDisposable != null) {
                    Disposer.dispose((Disposable)rootDisposable);
                }
            }
        }, (Disposable)project);
        RootType.ROOT_EP.addChangeListener(onUpdate, (Disposable)project);
    }

    private static void registerRootTypeUpdater(@NotNull Project project, @NotNull RootType rootType, @NotNull Runnable onUpdate, @NotNull Disposable parentDisposable, @NotNull Map<RootType, Disposable> disposables) {
        if (rootType.isHidden()) {
            return;
        }
        Disposable rootDisposable = disposables.get(rootType);
        Disposer.register((Disposable)parentDisposable, (Disposable)rootDisposable);
        ReadAction.nonBlocking(() -> rootType.registerTreeUpdater(project, parentDisposable, onUpdate)).expireWith(parentDisposable).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private static VirtualFile getNewParent(@NotNull VFileEvent e) {
        if (e instanceof VFileMoveEvent) {
            return ((VFileMoveEvent)e).getNewParent();
        }
        if (e instanceof VFileCopyEvent) {
            return ((VFileCopyEvent)e).getNewParent();
        }
        if (e instanceof VFileCreateEvent) {
            return ((VFileCreateEvent)e).getParent();
        }
        return Objects.requireNonNull(e.getFile()).getParent();
    }

    private static boolean isDirectory(@NotNull VFileEvent e) {
        if (e instanceof VFileCreateEvent) {
            return ((VFileCreateEvent)e).isDirectory();
        }
        return Objects.requireNonNull(e.getFile()).isDirectory();
    }

    @Nullable
    private static PsiDirectory getDirectory(@NotNull Project project, @NotNull RootType rootType) {
        VirtualFile virtualFile = ScratchTreeStructureProvider.getVirtualFile(rootType);
        return virtualFile == null ? null : PsiManager.getInstance((Project)project).findDirectory(virtualFile);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull RootType rootType) {
        String path = ScratchFileService.getInstance().getRootPath(rootType);
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Nullable
    private static AbstractTreeNode<?> createRootTypeNode(@NotNull Project project, @NotNull RootType rootType, @NotNull ViewSettings settings) {
        if (rootType.isHidden()) {
            return null;
        }
        MyRootNode node = new MyRootNode(project, rootType, settings);
        return node.isEmpty() ? null : node;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children2, ViewSettings settings) {
        Project project;
        Project project2 = project = parent instanceof ProjectViewProjectNode ? parent.getProject() : null;
        if (project == null) {
            return children2;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return children2;
        }
        if (children2.isEmpty() && JBIterable.from((Iterable)RootType.getAllRootTypes()).filterMap(o -> ScratchTreeStructureProvider.createRootTypeNode(project, o, settings)).isEmpty()) {
            return children2;
        }
        ArrayList list2 = new ArrayList(children2.size() + 1);
        list2.addAll(children2);
        list2.add((AbstractTreeNode<?>)new MyProjectNode(project, settings));
        return list2;
    }

    @Deprecated
    public static AbstractTreeNode<?> createRootNode(@NotNull Project project, ViewSettings settings) {
        return new MyProjectNode(project, settings);
    }

    @Nullable
    public Object getData(@NotNull Collection<AbstractTreeNode<?>> selected2, @NotNull String dataId) {
        AbstractTreeNode single;
        if (LangDataKeys.PASTE_TARGET_PSI_ELEMENT.is(dataId) && (single = (AbstractTreeNode)JBIterable.from(selected2).single()) instanceof MyRootNode) {
            VirtualFile file2 = ((MyRootNode)single).getVirtualFile();
            Project project = single.getProject();
            return file2 == null || project == null ? null : PsiManager.getInstance((Project)project).findDirectory(file2);
        }
        return null;
    }

    private static class MyRootNode
    extends ProjectViewNode<RootType>
    implements PsiFileSystemItemFilter {
        MyRootNode(Project project, @NotNull RootType type, ViewSettings settings) {
            super(project, (Object)type, settings);
        }

        @NotNull
        public RootType getRootType() {
            return (RootType)Objects.requireNonNull(this.getValue());
        }

        public boolean contains(@NotNull VirtualFile file2) {
            return ((RootType)this.getValue()).containsFile(file2);
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return ScratchTreeStructureProvider.getVirtualFile(this.getRootType());
        }

        @NotNull
        public Collection<VirtualFile> getRoots() {
            return MyRootNode.getDefaultRootsFor((VirtualFile)this.getVirtualFile());
        }

        @NotNull
        public Collection<? extends AbstractTreeNode<?>> getChildren() {
            return MyRootNode.getDirectoryChildrenImpl(this.getProject(), this.getDirectory(), this.getSettings(), this);
        }

        PsiDirectory getDirectory() {
            return ScratchTreeStructureProvider.getDirectory(this.getProject(), (RootType)this.getValue());
        }

        protected void update(@NotNull PresentationData presentation2) {
            presentation2.setIcon(AllIcons.Nodes.Folder);
            presentation2.setPresentableText(this.getRootType().getDisplayName());
        }

        public boolean canRepresent(Object element2) {
            return Comparing.equal((Object)this.getDirectory(), (Object)element2);
        }

        public boolean isEmpty() {
            VirtualFile root = this.getVirtualFile();
            if (root == null) {
                return true;
            }
            RootType rootType = this.getRootType();
            Project project = Objects.requireNonNull(this.getProject());
            for (VirtualFile f : root.getChildren()) {
                if (rootType.isIgnored(project, f)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean shouldShow(@NotNull PsiFileSystemItem item) {
            return !this.getRootType().isIgnored(this.getProject(), item.getVirtualFile());
        }

        @NotNull
        static Collection<AbstractTreeNode<?>> getDirectoryChildrenImpl(final @NotNull Project project, @Nullable PsiDirectory directory, final @NotNull ViewSettings settings, final @NotNull PsiFileSystemItemFilter filter2) {
            final ArrayList result2 = new ArrayList();
            PsiElementProcessor<PsiFileSystemItem> processor2 = new PsiElementProcessor<PsiFileSystemItem>(){

                public boolean execute(@NotNull PsiFileSystemItem element2) {
                    if (filter2.shouldShow(element2)) {
                        if (element2 instanceof PsiDirectory) {
                            result2.add(new PsiDirectoryNode(project, (PsiDirectory)element2, settings, filter2){

                                @Override
                                public Collection<AbstractTreeNode<?>> getChildrenImpl() {
                                    return MyRootNode.getDirectoryChildrenImpl(this.getProject(), (PsiDirectory)this.getValue(), this.getSettings(), this.getFilter());
                                }
                            });
                        } else if (element2 instanceof PsiFile) {
                            result2.add(new PsiFileNode(project, (PsiFile)element2, settings){

                                @Override
                                public Comparable<PsiFileNode.ExtensionSortKey> getTypeSortKey() {
                                    PsiFile value2 = (PsiFile)this.getValue();
                                    Language language = value2 == null ? null : value2.getLanguage();
                                    LanguageFileType fileType = language == null ? null : language.getAssociatedFileType();
                                    return fileType == null ? null : new PsiFileNode.ExtensionSortKey(fileType.getDefaultExtension());
                                }
                            });
                        }
                    }
                    return true;
                }
            };
            return (Collection)AbstractTreeUi.calculateYieldingToWriteAction(() -> MyRootNode.lambda$getDirectoryChildrenImpl$0(directory, (PsiElementProcessor)processor2, result2));
        }

        private static /* synthetic */ List lambda$getDirectoryChildrenImpl$0(PsiDirectory directory, PsiElementProcessor processor2, List result2) {
            if (directory == null || !directory.isValid()) {
                return Collections.emptyList();
            }
            directory.processChildren(processor2);
            return result2;
        }
    }

    private static final class MyProjectNode
    extends ProjectViewNode<String> {
        MyProjectNode(Project project, ViewSettings settings) {
            super(project, (Object)ScratchesNamedScope.scratchesAndConsoles(), settings);
        }

        public boolean contains(@NotNull VirtualFile file2) {
            return ScratchUtil.isScratch(file2);
        }

        @NotNull
        public Collection<? extends AbstractTreeNode<?>> getChildren() {
            ArrayList list2 = new ArrayList();
            Project project = Objects.requireNonNull(this.getProject());
            for (RootType rootType : RootType.getAllRootTypes()) {
                ContainerUtil.addIfNotNull(list2, (Object)ScratchTreeStructureProvider.createRootTypeNode(project, rootType, this.getSettings()));
            }
            return list2;
        }

        protected void update(@NotNull PresentationData presentation2) {
            presentation2.setPresentableText((String)this.getValue());
            presentation2.setIcon(AllIcons.Scope.Scratches);
        }

        public boolean canRepresent(Object element2) {
            VirtualFile virtualFile;
            PsiElement item = element2 instanceof PsiElement ? (PsiElement)element2 : null;
            VirtualFile virtualFile2 = virtualFile = item == null ? null : PsiUtilCore.getVirtualFile((PsiElement)item);
            if (virtualFile == null) {
                return false;
            }
            return Objects.equals(virtualFile.getPath(), FileUtil.toSystemIndependentName((String)PathManager.getScratchPath()));
        }
    }
}

