/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LRUPopupBuilder<T> {
    private static final Logger LOG = Logger.getInstance(LRUPopupBuilder.class);
    private static final int MAX_VISIBLE_SIZE = 20;
    private static final int LRU_ITEMS = 4;
    private final String myTitle;
    private final PropertiesComponent myPropertiesComponent;
    private final Map<T, Pair<String, Icon>> myPresentations = new IdentityHashMap<T, Pair<String, Icon>>();
    private T mySelection;
    private Consumer<? super T> myOnChosen;
    private Comparator<? super T> myComparator;
    private Iterable<? extends T> myItemsIterable;
    private JBIterable<T> myExtraItems = JBIterable.empty();

    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project, @NotNull String title, @NotNull Iterable<? extends VirtualFile> files2, @NotNull PerFileMappings<Language> mappings) {
        VirtualFile[] filesCopy = VfsUtilCore.toVirtualFileArray((Collection)JBIterable.from(files2).toList());
        Arrays.sort(filesCopy, (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (!o1.getFileSystem().isCaseSensitive() ? 1 : 0) != 0));
        return LRUPopupBuilder.forFileLanguages(project, title, null, (Consumer<? super Language>)((Consumer)t -> {
            try {
                WriteCommandAction.writeCommandAction((Project)project).withName(LangBundle.message((String)"command.name.change.language", (Object[])new Object[0])).run(() -> LRUPopupBuilder.changeLanguageWithUndo(project, t, filesCopy, mappings));
            }
            catch (UnexpectedUndoException e) {
                LOG.error((Throwable)e);
            }
        }));
    }

    @Deprecated
    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project, @Nullable Language selection, @NotNull Consumer<? super Language> onChosen) {
        return LRUPopupBuilder.forFileLanguages(project, "Languages", selection, onChosen);
    }

    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project, @NotNull @NlsContexts.PopupTitle String title, @Nullable Language selection, @NotNull Consumer<? super Language> onChosen) {
        return LRUPopupBuilder.languagePopupBuilder(project, title).forValues(LanguageUtil.getFileLanguages()).withSelection(selection).onChosen(onChosen).buildPopup();
    }

    @NotNull
    public static LRUPopupBuilder<Language> languagePopupBuilder(@NotNull Project project, @NotNull @NlsContexts.PopupTitle String title) {
        return new LRUPopupBuilder<Language>(project, title){

            @Override
            public String getDisplayName(Language language) {
                return language.getDisplayName();
            }

            @Override
            public Icon getIcon(Language language) {
                LanguageFileType associatedLanguage = language.getAssociatedFileType();
                return associatedLanguage != null ? associatedLanguage.getIcon() : null;
            }

            @Override
            public String getStorageId(Language language) {
                return language.getID();
            }
        }.withComparator(LanguageUtil.LANGUAGE_COMPARATOR);
    }

    protected LRUPopupBuilder(@NotNull Project project, @NotNull String title) {
        this.myTitle = title;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)project);
    }

    public abstract String getDisplayName(T var1);

    public abstract String getStorageId(T var1);

    public abstract Icon getIcon(T var1);

    @NotNull
    public LRUPopupBuilder<T> forValues(@Nullable Iterable<? extends T> items) {
        this.myItemsIterable = items;
        return this;
    }

    @NotNull
    public LRUPopupBuilder<T> withSelection(@Nullable T t) {
        this.mySelection = t;
        return this;
    }

    @NotNull
    public LRUPopupBuilder<T> withExtra(@NotNull T extra, @NotNull String displayName, @Nullable Icon icon2) {
        this.myExtraItems = this.myExtraItems.append(extra);
        this.myPresentations.put(extra, (Pair<String, Icon>)Pair.create((Object)displayName, (Object)icon2));
        return this;
    }

    @NotNull
    public LRUPopupBuilder<T> onChosen(@Nullable Consumer<? super T> consumer) {
        this.myOnChosen = consumer;
        return this;
    }

    public LRUPopupBuilder<T> withComparator(@Nullable Comparator<? super T> comparator2) {
        this.myComparator = comparator2;
        return this;
    }

    @NotNull
    public ListPopup buildPopup() {
        ArrayList ids = ContainerUtil.newArrayList((Object[])this.restoreLRUItems());
        if (this.mySelection != null) {
            ids.add(this.getStorageId(this.mySelection));
        }
        ArrayList<Object> lru = new ArrayList<Object>(4);
        ArrayList<? super T> items = new ArrayList<T>(20);
        final List extra = this.myExtraItems.toList();
        if (this.myItemsIterable != null) {
            for (T t : this.myItemsIterable) {
                (ids.contains(this.getStorageId(t)) ? lru : items).add(t);
            }
        }
        if (this.myComparator != null) {
            items.sort(this.myComparator);
        }
        if (!lru.isEmpty()) {
            lru.sort(Comparator.comparingInt(o -> ids.indexOf(this.getStorageId(o))));
        }
        final Object separator1 = !lru.isEmpty() && !items.isEmpty() ? items.get(0) : null;
        final Object separator2 = !lru.isEmpty() || !items.isEmpty() ? ContainerUtil.getFirstItem((List)extra) : null;
        List combinedItems = ContainerUtil.concat((List[])new List[]{lru, items, extra});
        BaseListPopupStep step = new BaseListPopupStep<T>(this.myTitle, combinedItems){

            @NotNull
            public String getTextFor(T t) {
                return t == null ? "" : (String)((LRUPopupBuilder)LRUPopupBuilder.this).getPresentation(t).first;
            }

            public Icon getIconFor(T t) {
                return t == null ? null : (Icon)((LRUPopupBuilder)LRUPopupBuilder.this).getPresentation(t).second;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(T t, boolean finalChoice) {
                if (!extra.contains(t)) {
                    LRUPopupBuilder.this.storeLRUItems(t);
                }
                if (LRUPopupBuilder.this.myOnChosen != null) {
                    this.doFinalStep(() -> LRUPopupBuilder.this.myOnChosen.consume(t));
                }
                return null;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(T value2) {
                return value2 == separator1 || value2 == separator2 ? new ListSeparator() : null;
            }
        };
        int selection = Math.max(0, this.mySelection != null ? combinedItems.indexOf(this.mySelection) : 0);
        step.setDefaultOptionIndex(selection);
        return LRUPopupBuilder.tweakSizeToPreferred(JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
    }

    @NotNull
    private Pair<String, Icon> getPresentation(T t) {
        Pair p = this.myPresentations.get(t);
        if (p == null) {
            p = Pair.create((Object)this.getDisplayName(t), (Object)this.getIcon(t));
            this.myPresentations.put(t, (Pair<String, Icon>)p);
        }
        return p;
    }

    @NotNull
    private static ListPopup tweakSizeToPreferred(@NotNull ListPopup popup2) {
        int nameLen = 0;
        ListPopupStep step = popup2.getListStep();
        List values2 = step.getValues();
        for (Object v : values2) {
            nameLen = Math.max(nameLen, step.getTextFor(v).length());
        }
        if (values2.size() > 20) {
            Dimension size = new JLabel(StringUtil.repeatSymbol((char)'a', (int)nameLen), EmptyIcon.ICON_16, 2).getPreferredSize();
            size.width += 20;
            size.height *= 20;
            popup2.setSize(size);
        }
        return popup2;
    }

    private String @NotNull [] restoreLRUItems() {
        return (String[])ObjectUtils.notNull((Object)this.myPropertiesComponent.getValues(this.getLRUKey()), (Object)ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    private void storeLRUItems(@NotNull T t) {
        String[] values2 = this.myPropertiesComponent.getValues(this.getLRUKey());
        ArrayList<String> lastUsed = new ArrayList<String>(4);
        lastUsed.add(this.getStorageId(t));
        if (values2 != null) {
            for (String value2 : values2) {
                if (!lastUsed.contains(value2)) {
                    lastUsed.add(value2);
                }
                if (lastUsed.size() == 4) break;
            }
        }
        this.myPropertiesComponent.setValues(this.getLRUKey(), ArrayUtilRt.toStringArray(lastUsed));
    }

    @NotNull
    private String getLRUKey() {
        return this.getClass().getName() + "/" + this.myTitle;
    }

    private static void changeLanguageWithUndo(@NotNull Project project, final @NotNull Language t, final VirtualFile @NotNull [] sortedFiles, final @NotNull PerFileMappings<Language> mappings) throws UnexpectedUndoException {
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Arrays.asList(sortedFiles));
        if (status.hasReadonlyFiles()) {
            return;
        }
        LinkedHashSet<VirtualFile> matchedExtensions = new LinkedHashSet<VirtualFile>();
        final HashMap<VirtualFile, Object> oldMapping = new HashMap<VirtualFile, Object>();
        for (VirtualFile file2 : sortedFiles) {
            oldMapping.put(file2, mappings.getMapping(file2));
            if (!ScratchUtil.hasMatchingExtension(project, file2)) continue;
            matchedExtensions.add(file2);
        }
        BasicUndoableAction action2 = new BasicUndoableAction(sortedFiles){

            public void undo() {
                for (VirtualFile file2 : sortedFiles) {
                    mappings.setMapping(file2, oldMapping.get(file2));
                }
            }

            public void redo() {
                for (VirtualFile file2 : sortedFiles) {
                    mappings.setMapping(file2, (Object)t);
                }
            }
        };
        action2.redo();
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)action2);
        for (VirtualFile file3 : matchedExtensions) {
            try {
                ScratchUtil.updateFileExtension(project, file3);
            }
            catch (IOException iOException) {}
        }
    }
}

