/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.ModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectViewModuleGroupNode
extends ModuleGroupNode {
    public ProjectViewModuleGroupNode(Project project, @NotNull ModuleGroup value2, ViewSettings viewSettings) {
        super(project, value2, viewSettings);
    }

    @Override
    @NotNull
    protected AbstractTreeNode createModuleNode(@NotNull Module module) {
        PsiDirectory psi;
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length == 1 && (psi = PsiManager.getInstance((Project)this.myProject).findDirectory(roots[0])) != null) {
            return new PsiDirectoryNode(this.myProject, psi, this.getSettings());
        }
        return new ProjectViewModuleNode(this.getProject(), module, this.getSettings());
    }

    @Override
    @NotNull
    protected ModuleGroupNode createModuleGroupNode(@NotNull ModuleGroup moduleGroup) {
        return new ProjectViewModuleGroupNode(this.getProject(), moduleGroup, this.getSettings());
    }

    @Override
    @NotNull
    protected List<Module> getModulesByFile(@NotNull VirtualFile file2) {
        return ContainerUtil.createMaybeSingletonList((Object)ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file2, false));
    }
}

