/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryGroupNode
extends ProjectViewNode<LibraryGroupElement> {
    public LibraryGroupNode(Project project, @NotNull LibraryGroupElement value2, ViewSettings viewSettings) {
        super(project, (Object)value2, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        OrderEntry[] orderEntries;
        Module module = ((LibraryGroupElement)this.getValue()).getModule();
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        ArrayList children2 = new ArrayList();
        for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
            JdkOrderEntry jdkOrderEntry;
            Sdk jdk;
            if (orderEntry instanceof LibraryOrderEntry) {
                LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                Library library = libraryOrderEntry.getLibrary();
                if (library == null) continue;
                String libraryName = library.getName();
                if (libraryName == null || libraryName.length() == 0) {
                    LibraryGroupNode.addLibraryChildren((LibraryOrSdkOrderEntry)libraryOrderEntry, children2, this.getProject(), this);
                    continue;
                }
                children2.add((AbstractTreeNode<?>)new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(module, (LibraryOrSdkOrderEntry)libraryOrderEntry), this.getSettings()));
                continue;
            }
            if (!(orderEntry instanceof JdkOrderEntry) || (jdk = (jdkOrderEntry = (JdkOrderEntry)orderEntry).getJdk()) == null) continue;
            children2.add((AbstractTreeNode<?>)new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(module, (LibraryOrSdkOrderEntry)jdkOrderEntry), this.getSettings()));
        }
        return children2;
    }

    public static void addLibraryChildren(LibraryOrSdkOrderEntry entry, List<? super AbstractTreeNode<?>> children2, Project project, ProjectViewNode node) {
        VirtualFile[] files2;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile file2 : files2 = entry instanceof LibraryOrderEntry ? LibraryGroupNode.getLibraryRoots((LibraryOrderEntry)entry) : entry.getRootFiles(OrderRootType.CLASSES)) {
            if (!file2.isValid()) continue;
            if (file2.isDirectory()) {
                PsiDirectory psiDir = psiManager.findDirectory(file2);
                if (psiDir == null) continue;
                children2.add((AbstractTreeNode<?>)new PsiDirectoryNode(project, psiDir, node.getSettings()));
                continue;
            }
            PsiFile psiFile = psiManager.findFile(file2);
            if (psiFile == null) continue;
            children2.add((AbstractTreeNode<?>)new PsiFileNode(project, psiFile, node.getSettings()));
        }
    }

    public String getTestPresentation() {
        return "Libraries";
    }

    public boolean contains(@NotNull VirtualFile file2) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        if (!index.isInLibrary(file2)) {
            return false;
        }
        return this.someChildContainsFile(file2, false);
    }

    public void update(@NotNull PresentationData presentation2) {
        presentation2.setPresentableText(IdeBundle.message((String)"node.projectview.libraries", (Object[])new Object[0]));
        presentation2.setIcon(PlatformIcons.LIBRARY_ICON);
    }

    public boolean canNavigate() {
        return ProjectSettingsService.getInstance(this.myProject).canOpenModuleLibrarySettings();
    }

    public void navigate(boolean requestFocus) {
        Module module = ((LibraryGroupElement)this.getValue()).getModule();
        ProjectSettingsService.getInstance(this.myProject).openModuleLibrarySettings(module);
    }

    public static VirtualFile @NotNull [] getLibraryRoots(@NotNull LibraryOrderEntry orderEntry) {
        Library library = orderEntry.getLibrary();
        if (library == null) {
            return VirtualFile.EMPTY_ARRAY;
        }
        OrderRootType[] rootTypes = LibraryType.DEFAULT_EXTERNAL_ROOT_TYPES;
        if (library instanceof LibraryEx) {
            if (((LibraryEx)library).isDisposed()) {
                return VirtualFile.EMPTY_ARRAY;
            }
            PersistentLibraryKind libKind = ((LibraryEx)library).getKind();
            if (libKind != null) {
                rootTypes = LibraryType.findByKind((LibraryKind)libKind).getExternalRootTypes();
            }
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (OrderRootType rootType : rootTypes) {
            files2.addAll(Arrays.asList(library.getFiles(rootType)));
        }
        return VfsUtilCore.toVirtualFileArray(files2);
    }
}

