/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.JBDateFormat;
import com.intellij.util.ui.tree.TreeUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import javax.swing.JTree;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJB\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/projectView/impl/ProjectViewRenderer;", "Lcom/intellij/ide/util/treeView/NodeRenderer;", "()V", "appendInplaceComments", "", "node", "Lcom/intellij/ide/projectView/ProjectViewNode;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "customizeCellRenderer", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.platform.lang.impl"})
public class ProjectViewRenderer
extends NodeRenderer {
    public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.customizeCellRenderer(tree, value2, selected2, expanded, leaf, row, hasFocus);
        Object userObject = TreeUtil.getUserObject((Object)value2);
        if (userObject instanceof ProjectViewNode && UISettings.Companion.getInstance().getShowInplaceComments()) {
            this.appendInplaceComments((ProjectViewNode)userObject);
        }
    }

    public final void appendInplaceComments(@Nullable Project project, @Nullable VirtualFile file2) {
        BasicFileAttributes basicFileAttributes;
        File ioFile = file2 == null || file2.isDirectory() || !file2.isInLocalFileSystem() ? null : VfsUtilCore.virtualToIoFile((VirtualFile)file2);
        try {
            basicFileAttributes = ioFile == null ? null : Files.readAttributes(Paths.get(ioFile.toURI()), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (Exception ex) {
            basicFileAttributes = null;
        }
        BasicFileAttributes attr = basicFileAttributes;
        if (attr != null) {
            this.append("  ");
            SimpleTextAttributes attributes = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES;
            this.append(JBDateFormat.getFormatter().formatDateTime(attr.lastModifiedTime().toMillis()), attributes);
            this.append(", " + StringUtil.formatFileSize((long)attr.size()), attributes);
        }
        if (Registry.is((String)"show.last.visited.timestamps") && file2 != null && project != null) {
            IdeDocumentHistoryImpl.appendTimestamp(project, (SimpleColoredComponent)this, file2);
        }
    }

    public final void appendInplaceComments(@NotNull ProjectViewNode<?> node) {
        AbstractTreeNode parentNode = node.getParent();
        Object content2 = node.getValue();
        if (content2 instanceof PsiFileSystemItem || !(content2 instanceof PsiElement) || parentNode != null && parentNode.getValue() instanceof PsiDirectory) {
            this.appendInplaceComments(node.getProject(), node.getVirtualFile());
        }
    }

    public ProjectViewRenderer() {
        this.setOpaque(false);
        this.setIconOpaque(false);
        this.setTransparentIconBackground(true);
    }
}

