/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectRootsUtil {
    private ProjectRootsUtil() {
    }

    public static boolean isSourceRoot(@NotNull PsiDirectory psiDirectory) {
        return ProjectRootsUtil.isSourceRoot(psiDirectory.getVirtualFile(), psiDirectory.getProject());
    }

    public static boolean isSourceRoot(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return directoryFile.equals(fileIndex.getSourceRootForFile(directoryFile));
    }

    public static boolean isInSource(@NotNull PsiDirectory directory) {
        return ProjectRootsUtil.isInSource(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean isInSource(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return projectFileIndex.isInSourceContent(directoryFile);
    }

    public static boolean isInTestSource(@NotNull PsiFile file2) {
        VirtualFile vFile = file2.getVirtualFile();
        return vFile != null && ProjectRootsUtil.isInTestSource(vFile, file2.getProject());
    }

    public static boolean isInTestSource(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return projectFileIndex.isInTestSourceContent(directoryFile);
    }

    public static boolean isModuleSourceRoot(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        return ProjectRootsUtil.getModuleSourceRoot(virtualFile, project) != null;
    }

    @Nullable
    public static SourceFolder getModuleSourceRoot(@NotNull VirtualFile root, @NotNull Project project) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = projectFileIndex.getModuleForFile(root);
        return module != null && !module.isDisposed() ? ProjectRootsUtil.findSourceFolder(module, root) : null;
    }

    public static boolean isLibraryRoot(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (projectFileIndex.isInLibraryClasses(directoryFile)) {
            VirtualFile parent = directoryFile.getParent();
            return parent == null || !projectFileIndex.isInLibraryClasses(parent);
        }
        return false;
    }

    public static boolean isModuleContentRoot(@NotNull PsiDirectory directory) {
        return ProjectRootsUtil.isModuleContentRoot(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean isModuleContentRoot(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile contentRootForFile = projectFileIndex.getContentRootForFile(directoryFile);
        return directoryFile.equals(contentRootForFile);
    }

    public static String findUnloadedModuleByContentRoot(@NotNull VirtualFile root, @NotNull Project project) {
        if (project.isDefault()) {
            return null;
        }
        DirectoryInfo info = DirectoryIndex.getInstance(project).getInfoForFile(root);
        if (info.isExcluded(root) && root.equals(info.getContentRoot()) && info.getUnloadedModuleName() != null) {
            return info.getUnloadedModuleName();
        }
        return null;
    }

    public static String findUnloadedModuleByFile(@NotNull VirtualFile file2, @NotNull Project project) {
        if (project.isDefault()) {
            return null;
        }
        DirectoryInfo info = DirectoryIndex.getInstance(project).getInfoForFile(file2);
        VirtualFile contentRoot = info.getContentRoot();
        if (info.isExcluded(file2) && contentRoot != null) {
            DirectoryInfo rootInfo = DirectoryIndex.getInstance(project).getInfoForFile(contentRoot);
            return rootInfo.getUnloadedModuleName();
        }
        return null;
    }

    public static boolean isProjectHome(@NotNull PsiDirectory psiDirectory) {
        return psiDirectory.getVirtualFile().equals(psiDirectory.getProject().getBaseDir());
    }

    public static boolean isOutsideSourceRoot(@NotNull PsiFile psiFile) {
        if (psiFile instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
        return !projectFileIndex.isInSource(file2) && !projectFileIndex.isInLibraryClasses(file2);
    }

    @Nullable
    public static SourceFolder findSourceFolder(@NotNull Module module, @NotNull VirtualFile root) {
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)module.getProject());
        SourceFolder folder = index.getModuleForFile(root) == module ? index.getSourceFolder(root) : null;
        return folder != null && root.equals(folder.getFile()) ? folder : null;
    }

    @Nullable
    public static ExcludeFolder findExcludeFolder(@NotNull Module module, @NotNull VirtualFile root) {
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (ExcludeFolder folder : entry.getExcludeFolders()) {
                if (!root.equals(folder.getFile())) continue;
                return folder;
            }
        }
        return null;
    }
}

