/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.HorizontalLayout;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginsGroupComponent
extends JBPanelWithEmptyText {
    private final EventHandler myEventHandler;
    private final Function<? super IdeaPluginDescriptor, ? extends ListPluginComponent> myFunction;
    private final List<UIPluginGroup> myGroups = new ArrayList<UIPluginGroup>();
    public static final Color SECTION_HEADER_FOREGROUND = JBColor.namedColor((String)"Plugins.SectionHeader.foreground", (Color)new JBColor(0x787878, 0x999999));
    private static final Color SECTION_HEADER_BACKGROUND = JBColor.namedColor((String)"Plugins.SectionHeader.background", (Color)new JBColor(0xF7F7F7, 3948353));

    public PluginsGroupComponent(@NotNull LayoutManager layout, @NotNull EventHandler eventHandler, @NotNull Function<? super IdeaPluginDescriptor, ? extends ListPluginComponent> function) {
        super(layout);
        this.myEventHandler = eventHandler;
        this.myFunction = function;
        this.myEventHandler.connect(this);
        this.setOpaque(true);
        this.setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
    }

    @NotNull
    public List<UIPluginGroup> getGroups() {
        return this.myGroups;
    }

    public void setSelectionListener(@Nullable Consumer<? super PluginsGroupComponent> listener2) {
        this.myEventHandler.setSelectionListener(listener2);
    }

    @NotNull
    public List<ListPluginComponent> getSelection() {
        return this.myEventHandler.getSelection();
    }

    public void setSelection(@NotNull ListPluginComponent component2) {
        this.myEventHandler.setSelection(component2);
    }

    public void setSelection(@NotNull List<? extends ListPluginComponent> components) {
        this.myEventHandler.setSelection(components);
    }

    public void addGroup(@NotNull PluginsGroup group) {
        this.addGroup(group, -1);
    }

    public void addGroup(@NotNull PluginsGroup group, int groupIndex) {
        this.addGroup(group, group.descriptors, groupIndex);
    }

    public void addLazyGroup(final @NotNull PluginsGroup group, final @NotNull JScrollBar scrollBar, final int gapSize, final @NotNull Runnable uiCallback) {
        if (group.descriptors.size() <= gapSize) {
            this.addGroup(group);
        } else {
            this.addGroup(group, group.descriptors.subList(0, gapSize), -1);
            AdjustmentListener listener2 = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    if (scrollBar.getValue() + scrollBar.getVisibleAmount() >= scrollBar.getMaximum()) {
                        int fromIndex = group.ui.plugins.size();
                        int toIndex = Math.min(fromIndex + gapSize, group.descriptors.size());
                        ListPluginComponent lastComponent = group.ui.plugins.get(fromIndex - 1);
                        int uiIndex = PluginsGroupComponent.this.getComponentIndex(lastComponent);
                        int eventIndex = PluginsGroupComponent.this.myEventHandler.getCellIndex(lastComponent);
                        PluginLogo.startBatchMode();
                        PluginsGroupComponent.this.addToGroup(group, group.descriptors.subList(fromIndex, toIndex), uiIndex, eventIndex);
                        PluginLogo.endBatchMode();
                        if (group.descriptors.size() == group.ui.plugins.size()) {
                            scrollBar.removeAdjustmentListener(this);
                            group.clearCallback = null;
                        }
                        uiCallback.run();
                    }
                }
            };
            group.clearCallback = () -> scrollBar.removeAdjustmentListener(listener2);
            scrollBar.addAdjustmentListener(listener2);
        }
    }

    private void addGroup(@NotNull PluginsGroup group, @NotNull List<? extends IdeaPluginDescriptor> descriptors, int groupIndex) {
        int eventIndex;
        int index;
        UIPluginGroup uiGroup;
        group.ui = uiGroup = new UIPluginGroup();
        this.myGroups.add(groupIndex == -1 ? this.myGroups.size() : groupIndex, uiGroup);
        OpaquePanel panel2 = new OpaquePanel((LayoutManager)new BorderLayout(), SECTION_HEADER_BACKGROUND);
        panel2.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        JLabel title = new JLabel(group.title){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                Container parent = this.getParent();
                Insets insets = parent.getInsets();
                size.width = Math.min(parent.getWidth() - insets.left - insets.right - (parent.getComponentCount() == 2 ? parent.getComponent(1).getWidth() + JBUIScale.scale((int)20) : 0), size.width);
                return size;
            }

            @Override
            public String getToolTipText() {
                return super.getPreferredSize().width > this.getWidth() ? super.getToolTipText() : null;
            }
        };
        title.setToolTipText(group.title);
        title.setForeground(SECTION_HEADER_FOREGROUND);
        panel2.add((Component)title, (Object)"West");
        group.titleLabel = title;
        if (group.rightAction != null) {
            panel2.add(group.rightAction, (Object)"East");
        } else if (!ContainerUtil.isEmpty(group.rightActions)) {
            NonOpaquePanel actions = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUIScale.scale((int)5))));
            panel2.add((Component)actions, (Object)"East");
            for (JComponent action2 : group.rightActions) {
                actions.add(action2);
            }
        }
        if (groupIndex == 0) {
            this.add((Component)panel2, 0);
            index = 1;
            eventIndex = 0;
        } else if (groupIndex == -1) {
            this.add((Component)panel2);
            eventIndex = -1;
            index = -1;
        } else {
            assert (groupIndex < this.myGroups.size());
            index = this.getComponentIndex(this.myGroups.get((int)(groupIndex + 1)).panel);
            assert (index != -1);
            this.add((Component)panel2, index++);
            eventIndex = this.getEventIndexForGroup(groupIndex + 1);
        }
        uiGroup.panel = panel2;
        this.addToGroup(group, descriptors, index, eventIndex);
    }

    private int getEventIndexForGroup(int groupIndex) {
        for (int i2 = groupIndex; i2 >= 0; --i2) {
            List<ListPluginComponent> plugins = this.myGroups.get((int)i2).plugins;
            if (plugins.isEmpty()) continue;
            return this.myEventHandler.getCellIndex(plugins.get(0));
        }
        return -1;
    }

    private void addToGroup(@NotNull PluginsGroup group, @NotNull List<? extends IdeaPluginDescriptor> descriptors, int index, int eventIndex) {
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors) {
            ListPluginComponent pluginComponent = (ListPluginComponent)this.myFunction.fun((Object)ideaPluginDescriptor);
            group.ui.plugins.add(pluginComponent);
            this.add(pluginComponent, index);
            this.myEventHandler.addCell(pluginComponent, eventIndex);
            pluginComponent.setListeners(this.myEventHandler);
            if (index != -1) {
                ++index;
            }
            if (eventIndex == -1) continue;
            ++eventIndex;
        }
    }

    public void addToGroup(@NotNull PluginsGroup group, @NotNull IdeaPluginDescriptor descriptor2) {
        int index = group.addWithIndex(descriptor2);
        ListPluginComponent anchor2 = null;
        int uiIndex = -1;
        if (index == group.ui.plugins.size()) {
            int groupIndex = this.myGroups.indexOf(group.ui);
            if (groupIndex < this.myGroups.size() - 1) {
                UIPluginGroup nextGroup = this.myGroups.get(groupIndex + 1);
                anchor2 = nextGroup.plugins.get(0);
                uiIndex = this.getComponentIndex(nextGroup.panel);
            }
        } else {
            anchor2 = group.ui.plugins.get(index);
            uiIndex = this.getComponentIndex(anchor2);
        }
        ListPluginComponent pluginComponent = (ListPluginComponent)this.myFunction.fun((Object)descriptor2);
        group.ui.plugins.add(index, pluginComponent);
        this.add(pluginComponent, uiIndex);
        this.myEventHandler.addCell(pluginComponent, anchor2);
        pluginComponent.setListeners(this.myEventHandler);
    }

    public void removeGroup(@NotNull PluginsGroup group) {
        this.myGroups.remove(group.ui);
        this.remove(group.ui.panel);
        for (ListPluginComponent plugin : group.ui.plugins) {
            plugin.close();
            this.remove(plugin);
            this.myEventHandler.removeCell(plugin);
        }
        this.myEventHandler.updateSelection();
        group.clear();
    }

    public void removeFromGroup(@NotNull PluginsGroup group, @NotNull IdeaPluginDescriptor descriptor2) {
        int index = ContainerUtil.indexOf(group.ui.plugins, component2 -> component2.myPlugin == descriptor2);
        assert (index != -1);
        ListPluginComponent component3 = group.ui.plugins.remove(index);
        component3.close();
        this.remove(component3);
        this.myEventHandler.removeCell(component3);
        if (component3.getSelection() == EventHandler.SelectionType.SELECTION) {
            this.myEventHandler.updateSelection();
        }
        group.descriptors.remove(descriptor2);
    }

    private int getComponentIndex(@NotNull Component component2) {
        int components = this.getComponentCount();
        for (int i2 = 0; i2 < components; ++i2) {
            if (this.getComponent(i2) != component2) continue;
            return i2;
        }
        return -1;
    }

    public void clear() {
        for (UIPluginGroup group : this.myGroups) {
            for (ListPluginComponent plugin : group.plugins) {
                plugin.close();
            }
        }
        this.myGroups.clear();
        this.myEventHandler.clear();
        this.removeAll();
    }

    public void initialSelection() {
        this.initialSelection(true);
    }

    public void initialSelection(boolean scrollAndFocus) {
        SwingUtilities.invokeLater(() -> {
            this.myEventHandler.initialSelection(scrollAndFocus);
            if (!this.myGroups.isEmpty()) {
                this.scrollRectToVisible(this.myGroups.get((int)0).panel.getBounds());
            }
        });
    }
}

