/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.BgProgressIndicator;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.OneLineProgressIndicator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.wm.ex.StatusBarEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallPluginInfo {
    public final BgProgressIndicator indicator = new BgProgressIndicator();
    private final IdeaPluginDescriptor myDescriptor;
    private MyPluginModel myPluginModel;
    public final boolean install;
    public final IdeaPluginDescriptor updateDescriptor;
    private TaskInfo myStatusBarTaskInfo;
    private boolean myClosed;
    private static boolean myShowRestart;
    private IdeaPluginDescriptorImpl myInstalledDescriptor;

    public InstallPluginInfo(@NotNull IdeaPluginDescriptor descriptor2, IdeaPluginDescriptor updateDescriptor, @NotNull MyPluginModel pluginModel, boolean install) {
        this.myDescriptor = descriptor2;
        this.updateDescriptor = updateDescriptor;
        this.myPluginModel = pluginModel;
        this.install = install;
    }

    public synchronized void toBackground(@Nullable StatusBarEx statusBar) {
        this.myPluginModel = null;
        this.indicator.removeStateDelegates();
        if (statusBar != null) {
            String title = (this.install ? "Installing plugin " : "Update plugin ") + this.myDescriptor.getName();
            this.myStatusBarTaskInfo = OneLineProgressIndicator.task(title);
            statusBar.addProgress(this.indicator, this.myStatusBarTaskInfo);
        }
    }

    public synchronized void fromBackground(@NotNull MyPluginModel pluginModel) {
        this.myPluginModel = pluginModel;
        myShowRestart = false;
        this.closeStatusBarIndicator();
    }

    public static void showRestart() {
        myShowRestart = true;
    }

    public synchronized void finish(boolean success, boolean cancel, boolean showErrors, boolean restartRequired) {
        if (this.myClosed) {
            return;
        }
        if (this.myPluginModel == null) {
            MyPluginModel.finishInstall(this.myDescriptor);
            this.closeStatusBarIndicator();
            if (success && !cancel && restartRequired) {
                myShowRestart = true;
            }
            if (MyPluginModel.myInstallingInfos.isEmpty() && myShowRestart) {
                myShowRestart = false;
                ApplicationManager.getApplication().invokeLater(() -> PluginManagerConfigurable.shutdownOrRestartApp());
            }
        } else if (!cancel) {
            this.myPluginModel.finishInstall(this.myDescriptor, this.myInstalledDescriptor, success, showErrors, restartRequired);
        }
    }

    private void closeStatusBarIndicator() {
        if (this.myStatusBarTaskInfo != null) {
            this.indicator.finish(this.myStatusBarTaskInfo);
            this.myStatusBarTaskInfo = null;
        }
    }

    public void close() {
        this.myClosed = true;
    }

    public IdeaPluginDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    public void setInstalledDescriptor(IdeaPluginDescriptorImpl installedDescriptor) {
        this.myInstalledDescriptor = installedDescriptor;
    }
}

