/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ColorButton
extends JButton {
    protected static final Color WhiteForeground = new JBColor(Color.white, new Color(0xBBBBBB));

    public ColorButton() {
        this.setOpaque(false);
    }

    protected final void setTextColor(@NotNull Color color) {
        this.putClientProperty("JButton.textColor", color);
    }

    protected final void setFocusedTextColor(@NotNull Color color) {
        this.putClientProperty("JButton.focusedTextColor", color);
    }

    protected final void setBgColor(@NotNull Color color) {
        this.putClientProperty("JButton.backgroundColor", color);
    }

    protected final void setFocusedBgColor(@NotNull Color color) {
        this.putClientProperty("JButton.focusedBackgroundColor", color);
    }

    protected final void setBorderColor(@NotNull Color color) {
        this.putClientProperty("JButton.borderColor", color);
    }

    protected final void setFocusedBorderColor(@NotNull Color color) {
        this.putClientProperty("JButton.focusedBorderColor", color);
    }

    public static void setWidth72(@NotNull JButton button2) {
        ColorButton.setWidth(button2, 72);
    }

    public static void setWidth(@NotNull JButton button2, int noScaleWidth) {
        int width = JBUIScale.scale((int)noScaleWidth);
        if (button2 instanceof JBOptionButton && button2.getComponentCount() == 2) {
            width += button2.getComponent((int)1).getPreferredSize().width;
        } else {
            Border border = button2.getBorder();
            if (border != null) {
                Insets insets = border.getBorderInsets(button2);
                width += insets.left + insets.right;
            }
        }
        button2.setPreferredSize(new Dimension(width, button2.getPreferredSize().height));
    }
}

