/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstallCallbackDataKt;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.openapi.editor.CustomFileDropHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Consumer;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginDropHandler
extends CustomFileDropHandler {
    @Override
    public boolean canHandle(@NotNull Transferable t, @Nullable Editor editor) {
        File file2 = PluginDropHandler.getFile(t);
        if (file2 == null) {
            return false;
        }
        String path = file2.getPath();
        return FileUtilRt.extensionEquals((String)path, (String)"jar") || FileUtilRt.extensionEquals((String)path, (String)"zip");
    }

    @Override
    public boolean handleDrop(@NotNull Transferable t, @Nullable Editor editor, Project project) {
        File file2 = PluginDropHandler.getFile(t);
        if (file2 == null) {
            return false;
        }
        return PluginInstaller.installFromDisk(new InstalledPluginsTableModel(), file2, (Consumer<? super PluginInstallCallbackData>)((Consumer)PluginInstallCallbackDataKt::installPluginFromCallbackData), null);
    }

    @Nullable
    private static File getFile(@NotNull Transferable t) {
        List<File> list2 = FileCopyPasteUtil.getFileList(t);
        return list2 == null || list2.size() != 1 ? null : list2.get(0);
    }
}

