/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DisabledPluginsState {
    public static final String DISABLED_PLUGINS_FILENAME = "disabled_plugins.txt";
    private static volatile Set<PluginId> ourDisabledPlugins;
    @Nullable
    private static Runnable disabledPluginListener;

    @ApiStatus.Internal
    public static void setDisabledPluginListener(@NotNull Runnable value2) {
        disabledPluginListener = value2;
    }

    public static void dontLoadDisabledPlugins() {
        ourDisabledPlugins = Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<PluginId> disabledPlugins) {
        Path file2 = Paths.get(configPath, DISABLED_PLUGINS_FILENAME);
        if (!Files.isRegularFile(file2, new LinkOption[0])) {
            return;
        }
        List requiredPlugins = StringUtil.split((String)System.getProperty("idea.required.plugins.id", ""), (String)",");
        try {
            boolean updateDisablePluginsList = false;
            try (BufferedReader reader = Files.newBufferedReader(file2);){
                String id2;
                while ((id2 = reader.readLine()) != null) {
                    if (!requiredPlugins.contains(id2 = id2.trim()) && !ApplicationInfoImpl.getShadowInstance().isEssentialPlugin(id2)) {
                        disabledPlugins.add(PluginId.getId((String)id2));
                        continue;
                    }
                    updateDisablePluginsList = true;
                }
            }
            finally {
                if (updateDisablePluginsList) {
                    PluginManagerCore.savePluginsList(disabledPlugins, file2, false);
                    DisabledPluginsState.fireEditDisablePlugins();
                }
            }
        }
        catch (IOException e) {
            DisabledPluginsState.getLogger().info("Unable to load disabled plugins list from " + file2, (Throwable)e);
        }
    }

    @NotNull
    public static Set<PluginId> disabledPlugins() {
        return Collections.unmodifiableSet(DisabledPluginsState.getDisabledIds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static Set<PluginId> getDisabledIds() {
        Set<PluginId> result2 = ourDisabledPlugins;
        if (result2 != null) {
            return result2;
        }
        if (System.getProperty("idea.ignore.disabled.plugins") != null) {
            return Collections.emptySet();
        }
        Class<PluginManagerCore> clazz = PluginManagerCore.class;
        synchronized (PluginManagerCore.class) {
            result2 = ourDisabledPlugins;
            if (result2 != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result2;
            }
            result2 = new LinkedHashSet<PluginId>();
            DisabledPluginsState.loadDisabledPlugins(PathManager.getConfigPath(), result2);
            ourDisabledPlugins = result2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result2;
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @NotNull
    public static List<String> getDisabledPlugins() {
        final Set<PluginId> list2 = DisabledPluginsState.getDisabledIds();
        return new AbstractList<String>(){

            @Override
            public boolean contains(Object o) {
                return list2.contains(o);
            }

            @Override
            public int size() {
                return list2.size();
            }

            @Override
            public String get(int index) {
                if (index < 0 || index >= list2.size()) {
                    throw new IndexOutOfBoundsException("index=" + index + " size=" + list2.size());
                }
                Iterator iterator2 = list2.iterator();
                for (int i2 = 0; i2 < index; ++i2) {
                    iterator2.next();
                }
                return ((PluginId)iterator2.next()).getIdString();
            }
        };
    }

    public static boolean disablePlugin(@NotNull PluginId id2) {
        Set<PluginId> disabledPlugins = DisabledPluginsState.getDisabledIds();
        return disabledPlugins.add(id2) && DisabledPluginsState.trySaveDisabledPlugins(disabledPlugins);
    }

    public static boolean enablePlugin(@NotNull PluginId id2) {
        Set<PluginId> disabledPlugins = DisabledPluginsState.getDisabledIds();
        return disabledPlugins.remove(id2) && DisabledPluginsState.trySaveDisabledPlugins(disabledPlugins);
    }

    public static void enablePlugins(@NotNull Collection<? extends PluginDescriptor> plugins, boolean enabled) {
        DisabledPluginsState.enablePluginsById(ContainerUtil.map(plugins, plugin -> plugin.getPluginId()), enabled);
    }

    public static void enablePluginsById(@NotNull Collection<PluginId> plugins, boolean enabled) {
        Set<PluginId> disabled = DisabledPluginsState.getDisabledIds();
        int sizeBefore = disabled.size();
        for (PluginId plugin : plugins) {
            IdeaPluginDescriptor pluginDescriptor;
            if (enabled) {
                disabled.remove(plugin);
            } else {
                disabled.add(plugin);
            }
            if ((pluginDescriptor = PluginManagerCore.getPlugin(plugin)) == null) continue;
            pluginDescriptor.setEnabled(enabled);
        }
        if (sizeBefore == disabled.size()) {
            return;
        }
        DisabledPluginsState.trySaveDisabledPlugins(disabled);
    }

    static boolean trySaveDisabledPlugins(@NotNull Collection<PluginId> disabledPlugins) {
        try {
            DisabledPluginsState.saveDisabledPlugins(disabledPlugins, false);
            return true;
        }
        catch (IOException e) {
            DisabledPluginsState.getLogger().warn("Unable to save disabled plugins list", (Throwable)e);
            return false;
        }
    }

    public static void saveDisabledPlugins(@NotNull Collection<PluginId> ids, boolean append) throws IOException {
        DisabledPluginsState.saveDisabledPlugins(PathManager.getConfigPath(), ids, append);
    }

    public static void saveDisabledPlugins(@NotNull String configPath, @NotNull Collection<PluginId> ids, boolean append) throws IOException {
        Path plugins = Paths.get(configPath, DISABLED_PLUGINS_FILENAME);
        PluginManagerCore.savePluginsList(ids, plugins, append);
        ourDisabledPlugins = null;
        DisabledPluginsState.fireEditDisablePlugins();
    }

    private static void fireEditDisablePlugins() {
        if (disabledPluginListener != null) {
            disabledPluginListener.run();
        }
    }

    @NotNull
    public static Logger getLogger() {
        return Logger.getInstance((String)"#com.intellij.ide.plugins.DisabledPluginsState");
    }

    static void invalidate() {
        ourDisabledPlugins = null;
    }
}

