/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.ListenerDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ContainerDescriptor {
    @Nullable
    List<ServiceDescriptor> services;
    @Nullable
    List<ComponentConfig> components;
    @Nullable
    List<ListenerDescriptor> listeners;
    @Nullable
    List<ExtensionPointImpl<?>> extensionPoints;
    transient Map<String, List<Element>> extensions;

    @NotNull
    public List<ServiceDescriptor> getServices() {
        return ContainerUtil.notNullize(this.services);
    }

    @NotNull
    public List<ComponentConfig> getComponents() {
        return ContainerUtil.notNullize(this.components);
    }

    @NotNull
    public List<ListenerDescriptor> getListeners() {
        return ContainerUtil.notNullize(this.listeners);
    }

    @Nullable
    public List<ExtensionPointImpl<?>> getExtensionPoints() {
        return this.extensionPoints;
    }

    void addService(@NotNull ServiceDescriptor serviceDescriptor) {
        if (this.services == null) {
            this.services = new ArrayList<ServiceDescriptor>();
        }
        this.services.add(serviceDescriptor);
    }

    @NotNull
    List<ComponentConfig> getComponentListToAdd(int size) {
        List<ComponentConfig> result2 = this.components;
        if (result2 == null) {
            this.components = result2 = new ArrayList<ComponentConfig>(size);
        } else {
            ((ArrayList)result2).ensureCapacity(result2.size() + size);
        }
        return result2;
    }

    void merge(@NotNull ContainerDescriptor another) {
        this.components = ContainerDescriptor.concatOrNull(this.components, another.components);
        this.services = ContainerDescriptor.concatOrNull(this.services, another.services);
        this.extensionPoints = ContainerDescriptor.concatOrNull(this.extensionPoints, another.extensionPoints);
        this.listeners = ContainerDescriptor.concatOrNull(this.listeners, another.listeners);
    }

    @Nullable
    static <T> List<T> concatOrNull(@Nullable List<T> l1, @Nullable List<T> l2) {
        if (l1 == null) {
            return l2;
        }
        if (l2 == null) {
            return l1;
        }
        return ContainerUtil.concat(l1, l2);
    }
}

