/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarModelBuilder;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarModelBuilderImpl
extends NavBarModelBuilder {
    @Override
    public void traverseToRoot(@NotNull PsiElement psiElement, @NotNull Set<VirtualFile> roots, @NotNull List<Object> model, @Nullable NavBarModelExtension ownerExtension) {
        List extensions2 = NavBarModelExtension.EP_NAME.getExtensionList();
        PsiElement e = NavBarModelBuilderImpl.normalize(psiElement, ownerExtension);
        PsiElement next = null;
        while (e != null && !model.contains(e)) {
            model.add(e);
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)e);
            if (roots.contains(vFile)) break;
            for (NavBarModelExtension ext : extensions2) {
                PsiElement parent = ext.getParent(e);
                if (parent == null || parent == e) continue;
                next = parent;
                break;
            }
            e = NavBarModelBuilderImpl.normalize(next, ownerExtension);
            next = null;
        }
    }

    protected static PsiElement normalize(@Nullable PsiElement e) {
        return NavBarModel.normalize(NavBarModelBuilderImpl.getOriginalElement(e));
    }

    @Nullable
    protected static PsiElement normalize(@Nullable PsiElement e, NavBarModelExtension ownerExtension) {
        PsiElement originalElement = NavBarModelBuilderImpl.getOriginalElement(e);
        if (ownerExtension != null) {
            return originalElement != null ? ownerExtension.adjustElement(originalElement) : null;
        }
        return NavBarModel.normalize(originalElement);
    }

    @Nullable
    private static PsiElement getOriginalElement(@Nullable PsiElement e) {
        if (e == null || !e.isValid()) {
            return null;
        }
        PsiFile containingFile = e.getContainingFile();
        if (containingFile != null && containingFile.getVirtualFile() == null) {
            return null;
        }
        PsiElement orig = e.getOriginalElement();
        return !(e instanceof PsiCompiledElement) && orig instanceof PsiCompiledElement ? e : orig;
    }
}

