/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.execution.ExecutionBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.ContentRootMacro;
import com.intellij.ide.macro.FilePromptMacro;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroFilter;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MacrosDialog
extends DialogWrapper {
    private final DefaultListModel<Item> myMacrosModel = new DefaultListModel();
    private final JBList<Item> myMacrosList = new JBList(this.myMacrosModel);
    private final JTextArea myPreviewTextarea = new JTextArea();

    public MacrosDialog(Project project) {
        super(project, true);
        MacroManager.getInstance().cacheMacrosPreview(SimpleDataContext.getProjectContext(project));
        this.init();
    }

    public MacrosDialog(@NotNull Component parent, @NotNull Predicate<? super Macro> filter2, @Nullable Map<String, String> userMacros) {
        super(parent, true);
        MacroManager.getInstance().cacheMacrosPreview(DataManager.getInstance().getDataContext(parent));
        this.init(filter2, userMacros);
    }

    public static void addTextFieldExtension(@NotNull ExtendableTextField textField2) {
        MacrosDialog.addTextFieldExtension(textField2, Filters.ALL, null);
    }

    public static void addTextFieldExtension(@NotNull ExtendableTextField textField2, @NotNull Predicate<? super Macro> macroFilter, @Nullable Map<String, String> userMacros) {
        textField2.addExtension(ExtendableTextComponent.Extension.create((Icon)AllIcons.General.InlineAdd, (Icon)AllIcons.General.InlineAddHover, (String)ExecutionBundle.message((String)"insert.macros", (Object[])new Object[0]), () -> MacrosDialog.show((JTextComponent)textField2, macroFilter, userMacros)));
    }

    public static void addMacroSupport(@NotNull ExtendableTextField textField2, @NotNull Predicate<? super Macro> macroFilter, Computable<Boolean> hasModule) {
        textField2.addExtension(ExtendableTextComponent.Extension.create((Icon)AllIcons.General.InlineAdd, (Icon)AllIcons.General.InlineAddHover, (String)ExecutionBundle.message((String)"insert.macros", (Object[])new Object[0]), () -> MacrosDialog.show((JTextComponent)textField2, macroFilter, MacrosDialog.getPathMacros((Boolean)hasModule.compute()))));
    }

    public static void show(@NotNull JTextComponent textComponent) {
        MacrosDialog.show(textComponent, Filters.ALL, null);
    }

    public static void show(@NotNull JTextComponent textComponent, @NotNull Predicate<? super Macro> filter2, @Nullable Map<String, String> userMacros) {
        String macro;
        MacrosDialog dialog2 = new MacrosDialog(textComponent, filter2, userMacros);
        if (dialog2.showAndGet() && (macro = dialog2.getSelectedMacroName()) != null) {
            int position = textComponent.getCaretPosition();
            int selectionStart = textComponent.getSelectionStart();
            int selectionEnd = textComponent.getSelectionEnd();
            try {
                if (selectionStart < selectionEnd) {
                    textComponent.getDocument().remove(selectionStart, selectionEnd - selectionStart);
                    position = selectionStart;
                }
                String nameToInsert = macro.startsWith("$") || macro.startsWith("%") ? macro : "$" + macro + "$";
                textComponent.getDocument().insertString(position, nameToInsert, null);
                textComponent.setCaretPosition(position + nameToInsert.length());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        IdeFocusManager.findInstance().requestFocus((Component)textComponent, true);
    }

    protected void init() {
        throw new UnsupportedOperationException("Call init(...) overload accepting parameters");
    }

    private void init(@NotNull Predicate<? super Macro> filter2, @Nullable Map<String, String> userMacros) {
        super.init();
        this.setTitle(IdeBundle.message((String)"title.macros", (Object[])new Object[0]));
        this.setOKButtonText(IdeBundle.message((String)"button.insert", (Object[])new Object[0]));
        List macros = ContainerUtil.filter(MacroManager.getInstance().getMacros(), macro -> MacroFilter.GLOBAL.accept((Macro)macro) && filter2.test((Macro)macro));
        macros.sort(new Comparator<Macro>(){
            private final String ZERO = new String(new char[]{'\u0000'});

            @Override
            public int compare(Macro macro1, Macro macro2) {
                String name1 = macro1.getName();
                String name2 = macro2.getName();
                if (!StringUtil.startsWithChar((CharSequence)name1, (char)'/')) {
                    name1 = this.ZERO + name1;
                }
                if (!StringUtil.startsWithChar((CharSequence)name2, (char)'/')) {
                    name2 = this.ZERO + name2;
                }
                return name1.compareToIgnoreCase(name2);
            }
        });
        if (userMacros != null && !userMacros.isEmpty()) {
            for (Map.Entry<String, String> entry : userMacros.entrySet()) {
                this.myMacrosModel.addElement(new EntryWrapper(entry));
            }
        }
        MacroWrapper firstMacro = null;
        for (Macro macro3 : macros) {
            MacroWrapper element2 = new MacroWrapper(macro3);
            if (firstMacro == null) {
                firstMacro = element2;
            }
            this.myMacrosModel.addElement(element2);
        }
        final MacroWrapper macroWrapper = firstMacro;
        this.myMacrosList.setCellRenderer(new GroupedItemsListRenderer(new ListItemDescriptorAdapter<Item>(){

            public String getTextFor(Item value2) {
                return value2.toString();
            }

            public boolean hasSeparatorAboveOf(Item value2) {
                return value2 == macroWrapper;
            }
        }));
        this.addListeners();
        if (this.myMacrosModel.size() > 0) {
            this.myMacrosList.setSelectedIndex(0);
        } else {
            this.setOKActionEnabled(false);
        }
    }

    protected String getHelpId() {
        return "reference.settings.ide.settings.external.tools.macros";
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.macro.MacrosDialog";
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridy = 0;
        constr.anchor = 17;
        constr.fill = 2;
        panel2.add((Component)SeparatorFactory.createSeparator((String)IdeBundle.message((String)"label.macros", (Object[])new Object[0]), null), constr);
        constr = new GridBagConstraints();
        constr.gridy = 1;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.fill = 1;
        constr.anchor = 17;
        panel2.add((Component)ScrollPaneFactory.createScrollPane(this.myMacrosList), constr);
        this.myMacrosList.setSelectionMode(0);
        this.myMacrosList.setPreferredSize(null);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 2;
        constr.anchor = 17;
        constr.fill = 2;
        panel2.add((Component)SeparatorFactory.createSeparator((String)IdeBundle.message((String)"label.macro.preview", (Object[])new Object[0]), null), constr);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 3;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.fill = 1;
        constr.anchor = 17;
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myPreviewTextarea), constr);
        this.myPreviewTextarea.setEditable(false);
        this.myPreviewTextarea.setLineWrap(true);
        this.myPreviewTextarea.setPreferredSize(null);
        panel2.setPreferredSize((Dimension)JBUI.size((int)400, (int)500));
        return panel2;
    }

    @NotNull
    public static HashMap<String, String> getPathMacros(boolean addModuleMacros) {
        HashMap<String, String> macros = new HashMap<String, String>(PathMacros.getInstance().getUserMacros());
        if (addModuleMacros) {
            macros.put("MODULE_DIR", PathMacros.getInstance().getValue("MODULE_DIR"));
            macros.put("%MODULE_WORKING_DIR%", PathMacros.getInstance().getValue("MODULE_WORKING_DIR"));
        }
        return macros;
    }

    private void addListeners() {
        this.myMacrosList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Item item = (Item)MacrosDialog.this.myMacrosList.getSelectedValue();
                if (item == null) {
                    MacrosDialog.this.myPreviewTextarea.setText("");
                    MacrosDialog.this.setOKActionEnabled(false);
                } else {
                    MacrosDialog.this.myPreviewTextarea.setText(item.getPreview());
                    MacrosDialog.this.setOKActionEnabled(true);
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (MacrosDialog.this.getSelectedMacroName() != null) {
                    MacrosDialog.this.close(0);
                    return true;
                }
                return false;
            }
        }.installOn(this.myMacrosList);
    }

    @Deprecated
    public Macro getSelectedMacro() {
        Item item = (Item)this.myMacrosList.getSelectedValue();
        if (item instanceof MacroWrapper) {
            return ((MacroWrapper)item).myMacro;
        }
        return null;
    }

    @Nullable
    public String getSelectedMacroName() {
        Item item = (Item)this.myMacrosList.getSelectedValue();
        if (item == null) {
            return null;
        }
        return item.getName();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMacrosList;
    }

    public static final class Filters {
        private static final Pattern CAMEL_HUMP_START_PATTERN = Pattern.compile("(?<=[\\p{Lower}\\p{Digit}])(?![\\p{Lower}\\p{Digit}])");
        @NotNull
        public static final Predicate<? super Macro> ALL = m -> true;
        @NotNull
        public static final Predicate<? super Macro> NONE = m -> false;
        @NotNull
        public static final Predicate<? super Macro> ANY_PATH = m -> Filters.nameContains(m, "File") || Filters.nameContains(m, "Dir") || m instanceof ContentRootMacro || m instanceof FilePromptMacro;
        @NotNull
        public static final Predicate<? super Macro> DIRECTORY_PATH = m -> Filters.nameContains(m, "Dir") || m instanceof ContentRootMacro || m instanceof FilePromptMacro;
        @NotNull
        public static final Predicate<? super Macro> FILE_PATH = m -> Filters.nameContains(m, "File") && !Filters.nameContains(m, "Dir") || m instanceof FilePromptMacro;

        private Filters() {
        }

        private static boolean nameContains(@NotNull Macro m, @NotNull String part) {
            String[] nameParts = CAMEL_HUMP_START_PATTERN.split(m.getName());
            return ArrayUtil.contains((String)part, (String[])nameParts);
        }
    }

    private static final class EntryWrapper
    implements Item {
        private final Map.Entry<String, String> myEntry;

        EntryWrapper(Map.Entry<String, String> entry) {
            this.myEntry = entry;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myEntry.getKey();
        }

        @Override
        @NotNull
        public String getPreview() {
            return StringUtil.notNullize((String)this.myEntry.getValue(), (String)("$" + this.getName() + "$"));
        }

        @Override
        @NotNull
        public String toString() {
            return this.myEntry.getKey();
        }
    }

    private static final class MacroWrapper
    implements Item {
        private final Macro myMacro;

        MacroWrapper(Macro macro) {
            this.myMacro = macro;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myMacro.getName();
        }

        @Override
        @NotNull
        public String getPreview() {
            return StringUtil.notNullize((String)this.myMacro.preview());
        }

        @Override
        @NotNull
        public String toString() {
            return this.myMacro.getName() + " - " + this.myMacro.getDescription();
        }
    }

    private static interface Item {
        @NotNull
        public String getName();

        @NotNull
        public String getPreview();

        @NotNull
        public String toString();
    }
}

