/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.statusBar;

import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorInfoImpl;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightEditAbstractPopupWidgetWrapper
implements StatusBarWidget,
LightEditorListener,
CustomStatusBarWidget {
    private final NotNullLazyValue<EditorBasedStatusBarPopup> myOriginalInstance = NotNullLazyValue.createValue(() -> this.createOriginalWidget());
    @Nullable
    private Editor myEditor;

    protected DataContext getEditorDataContext(@NotNull DataContext originalContext) {
        return SimpleDataContext.getSimpleContext(CommonDataKeys.EDITOR.getName(), this.myEditor, originalContext);
    }

    @Nullable
    protected Editor getLightEditor() {
        return this.myEditor;
    }

    @NotNull
    protected abstract EditorBasedStatusBarPopup createOriginalWidget();

    @NotNull
    private EditorBasedStatusBarPopup getOriginalWidget() {
        return (EditorBasedStatusBarPopup)this.myOriginalInstance.getValue();
    }

    public void install(@NotNull StatusBar statusBar) {
        this.getOriginalWidget().install(statusBar);
        LightEditService.getInstance().getEditorManager().addListener((LightEditorListener)this);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.getOriginalWidget());
    }

    public void afterSelect(@Nullable LightEditorInfo editorInfo) {
        this.myEditor = LightEditorInfoImpl.getEditor(editorInfo);
        this.getOriginalWidget().setEditor(this.myEditor);
        this.getOriginalWidget().update();
    }

    public JComponent getComponent() {
        return this.getOriginalWidget().getComponent();
    }
}

