/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.project;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.project.LightEditDirectoryIndex;
import com.intellij.ide.lightEdit.project.LightEditDumbService;
import com.intellij.ide.lightEdit.project.LightEditFileEditorManagerImpl;
import com.intellij.ide.lightEdit.project.LightEditFileIndexFacade;
import com.intellij.ide.lightEdit.project.LightEditProjectFileIndex;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.impl.ProjectExImpl;
import com.intellij.openapi.project.impl.ProjectLoadHelper;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LightEditProjectImpl
extends ProjectExImpl
implements LightEditCompatible {
    private static final Logger LOG = Logger.getInstance(LightEditProjectImpl.class);
    private static final String NAME = "LightEditProject";

    LightEditProjectImpl() {
        this(LightEditProjectImpl.getProjectPath());
    }

    private LightEditProjectImpl(@NotNull Path projectPath) {
        super(projectPath, NAME);
        ProjectLoadHelper.registerComponents(this);
        this.customizeRegisteredComponents();
        this.getStateStore().setPath(projectPath, false, null);
        this.init(null);
    }

    private void customizeRegisteredComponents() {
        IdeaPluginDescriptor pluginDescriptor = PluginManagerCore.getPlugin(PluginManagerCore.CORE_ID);
        if (pluginDescriptor == null) {
            LOG.error("Could not find plugin by id: " + PluginManagerCore.CORE_ID);
            return;
        }
        this.registerService(DirectoryIndex.class, LightEditDirectoryIndex.class, (PluginDescriptor)pluginDescriptor, true);
        this.registerService(ProjectFileIndex.class, LightEditProjectFileIndex.class, (PluginDescriptor)pluginDescriptor, true);
        this.registerService(FileIndexFacade.class, LightEditFileIndexFacade.class, (PluginDescriptor)pluginDescriptor, true);
        this.registerService(DumbService.class, LightEditDumbService.class, (PluginDescriptor)pluginDescriptor, true);
        this.registerComponent(FileEditorManager.class, LightEditFileEditorManagerImpl.class, (PluginDescriptor)pluginDescriptor, true);
    }

    @NotNull
    private static Path getProjectPath() {
        return Paths.get(PathManager.getConfigPath() + File.separator + "light-edit", new String[0]);
    }

    @Override
    public void init(@Nullable ProgressIndicator indicator) {
        this.createComponents(null);
    }

    @Override
    public void setProjectName(@NotNull String name) {
        throw new IllegalStateException();
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public String getLocationHash() {
        return this.getName();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }
}

