/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.project;

import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorInfoImpl;
import com.intellij.ide.lightEdit.LightEditorManagerImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LightEditFileEditorManagerImpl
extends FileEditorManagerImpl {
    LightEditFileEditorManagerImpl(@NotNull Project project) {
        super(project);
    }

    @Override
    public void loadState(@NotNull Element state) {
    }

    @Override
    @Nullable
    public Element getState() {
        return null;
    }

    @Override
    public boolean isProblem(@NotNull VirtualFile file2) {
        return false;
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileImpl2(@NotNull EditorWindow window, @NotNull VirtualFile file2, boolean focusEditor) {
        LightEditService.getInstance().openFile(file2, true);
        return this.getEditorsWithProviders(file2);
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file2) {
        FileEditorWithProvider data2 = this.getSelectedEditorWithProvider(file2);
        return data2 != null ? Pair.create((Object)new FileEditor[]{data2.getFileEditor()}, (Object)new FileEditorProvider[]{data2.getProvider()}) : Pair.create((Object)FileEditor.EMPTY_ARRAY, (Object)new FileEditorProvider[0]);
    }

    @Override
    @Nullable
    public FileEditorWithProvider getSelectedEditorWithProvider(@NotNull VirtualFile file2) {
        LightEditorManagerImpl editorManager = (LightEditorManagerImpl)LightEditService.getInstance().getEditorManager();
        LightEditorInfoImpl editorInfo = (LightEditorInfoImpl)editorManager.findOpen(file2);
        if (editorInfo != null) {
            return new FileEditorWithProvider(editorInfo.getFileEditor(), editorInfo.getProvider());
        }
        return null;
    }

    @Override
    @Nullable
    public FileEditor getSelectedEditor() {
        return LightEditService.getInstance().getSelectedFileEditor();
    }

    @Override
    public Editor getSelectedTextEditor() {
        return LightEditorInfoImpl.getEditor(this.getSelectedEditor());
    }

    @Override
    public VirtualFile @NotNull [] getOpenFiles() {
        return VfsUtilCore.toVirtualFileArray((Collection)LightEditService.getInstance().getEditorManager().getOpenFiles());
    }

    @Override
    public boolean isFileOpen(@NotNull VirtualFile file2) {
        return LightEditService.getInstance().getEditorManager().isFileOpen(file2);
    }

    @Override
    public boolean hasOpenedFile() {
        return !LightEditService.getInstance().getEditorManager().getOpenFiles().isEmpty();
    }

    @Override
    public VirtualFile @NotNull [] getSelectedFiles() {
        VirtualFile[] virtualFileArray;
        VirtualFile file2 = LightEditService.getInstance().getSelectedFile();
        if (file2 != null) {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = file2;
        } else {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        }
        return virtualFileArray;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return LightEditService.getInstance().getSelectedFile();
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor) {
        VirtualFile file2 = editor.getFile();
        if (file2 != null) {
            return file2;
        }
        FileEditorLocation location = editor.getCurrentLocation();
        if (location != null) {
            return location.getEditor().getFile();
        }
        LightEditorManagerImpl editorManager = (LightEditorManagerImpl)LightEditService.getInstance().getEditorManager();
        for (VirtualFile openFile2 : editorManager.getOpenFiles()) {
            LightEditorInfo editorInfo = editorManager.findOpen(openFile2);
            if (editorInfo == null || !editorInfo.getFileEditor().equals(editor)) continue;
            return openFile2;
        }
        return null;
    }

    @Override
    public boolean hasOpenFiles() {
        return !LightEditService.getInstance().getEditorManager().getOpenFiles().isEmpty();
    }
}

