/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.actions;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.intentions.openInProject.LightEditOpenInProjectIntention;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class LightEditOpenFileInProjectAction
extends DumbAwareAction
implements LightEditCompatible {
    public LightEditOpenFileInProjectAction() {
        super(ActionsBundle.messagePointer((String)"action.LightEditOpenFileInProjectAction.text", (Object[])new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation2 = e.getPresentation();
        if (!LightEdit.owns((Project)e.getProject())) {
            presentation2.setEnabledAndVisible(false);
        } else {
            presentation2.setVisible(true);
            VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            presentation2.setEnabled(file2 != null && file2.isInLocalFileSystem());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file2 != null) {
            LightEditOpenInProjectIntention.performOn(file2);
        }
    }
}

