/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.gdpr.ConsentAttributes;
import com.intellij.ide.gdpr.ConsentBase;
import com.intellij.ide.gdpr.Version;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfirmedConsent
extends ConsentBase {
    private boolean myIsAccepted;
    private long myAcceptanceTime;

    public ConfirmedConsent(ConsentAttributes attributes) {
        this(attributes.consentId, Version.fromString(attributes.version), attributes.accepted, attributes.acceptanceTime);
    }

    public ConfirmedConsent(String id2, Version version2, boolean accepted, long acceptanceTime) {
        super(id2, version2);
        this.myIsAccepted = accepted;
        this.myAcceptanceTime = acceptanceTime;
    }

    @Override
    public boolean isAccepted() {
        return this.myIsAccepted;
    }

    public long getAcceptanceTime() {
        return this.myAcceptanceTime;
    }

    public void setAccepted(boolean accepted) {
        this.myIsAccepted = accepted;
    }

    public void setAcceptanceTime(long acceptanceTime) {
        this.myAcceptanceTime = acceptanceTime;
    }

    @Override
    public String toString() {
        return "AcceptedConsent{id='" + this.getId() + '\'' + ", version='" + this.getVersion() + '\'' + ", accepted=" + this.myIsAccepted + ", acceptanceTime=" + this.myAcceptanceTime + '}';
    }

    public String toExternalString() {
        return this.getId() + ":" + this.getVersion().toString() + ":" + (this.isAccepted() ? "1" : "0") + ":" + this.myAcceptanceTime;
    }

    @Nullable
    public static ConfirmedConsent fromString(@NotNull String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, ":", false);
        if (tokenizer.hasMoreTokens()) {
            String id2 = tokenizer.nextToken().trim();
            if (tokenizer.hasMoreTokens()) {
                Version ver = Version.fromString(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    try {
                        Boolean _accepted;
                        int accepted = Integer.parseInt(tokenizer.nextToken());
                        Boolean bl = accepted == 1 ? Boolean.TRUE : (_accepted = accepted == 0 ? Boolean.FALSE : null);
                        if (_accepted != null && tokenizer.hasMoreTokens()) {
                            return new ConfirmedConsent(id2, ver, _accepted, Long.parseLong(tokenizer.nextToken()));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }
}

