/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.extensionResources;

import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class RestoreBundledExtensionsAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean isDirectory = file2 != null && file2.isDirectory();
        e.getPresentation().setEnabledAndVisible(isDirectory && ExtensionsRootType.getInstance().getPath(file2) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final ExtensionsRootType extensionsRootType = ExtensionsRootType.getInstance();
        final VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        final PluginId pluginId = extensionsRootType.getOwner(file2);
        final String path = extensionsRootType.getPath(file2);
        assert (file2 != null && pluginId != null && path != null);
        Task.Backgroundable extractResourcesInBackground = new Task.Backgroundable(e.getProject(), LangBundle.message((String)"progress.title.extracting.bundled.extensions.for.plugin", (Object[])new Object[]{pluginId.getIdString()})){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    extensionsRootType.extractBundledResources(pluginId, path);
                    VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
                }
                catch (IOException ex) {
                    ExtensionsRootType.LOG.warn("Failed to extract bundled extensions for " + file2.getPath(), (Throwable)ex);
                }
            }
        };
        ProgressManager.getInstance().run((Task)extractResourcesInBackground);
    }
}

