/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.mixed;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.mixed.SESearcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class MultiThreadSearcher
implements SESearcher {
    private static final Logger LOG = Logger.getInstance(MultiThreadSearcher.class);
    @NotNull
    private final SESearcher.Listener myListener;
    @NotNull
    private final Executor myNotificationExecutor;
    @NotNull
    private final SEResultsEqualityProvider myEqualityProvider;

    MultiThreadSearcher(@NotNull SESearcher.Listener listener2, @NotNull Executor notificationExecutor, @NotNull Collection<? extends SEResultsEqualityProvider> equalityProviders) {
        this.myListener = listener2;
        this.myNotificationExecutor = notificationExecutor;
        this.myEqualityProvider = SEResultsEqualityProvider.composite(equalityProviders);
    }

    @Override
    public ProgressIndicator search(@NotNull Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, @NotNull String pattern) {
        LOG.debug("Search started for pattern [", new Object[]{pattern, "]"});
        Collection<Object> contributors = contributorsAndLimits.keySet();
        if (pattern.isEmpty()) {
            contributors = ApplicationManager.getApplication().isUnitTestMode() ? Collections.emptySet() : ContainerUtil.filter(contributors, contributor -> contributor.isEmptyPatternSupported());
        }
        Function<ProgressIndicator, ResultsAccumulator> accumulatorSupplier = indicator -> new ResultsAccumulator((Map<? extends SearchEverywhereContributor<?>, Integer>)contributorsAndLimits, this.myEqualityProvider, this.myListener, this.myNotificationExecutor, (ProgressIndicator)indicator);
        return MultiThreadSearcher.performSearch(contributors, pattern, accumulatorSupplier);
    }

    @Override
    public ProgressIndicator findMoreItems(@NotNull Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> alreadyFound, @NotNull Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, @NotNull String pattern) {
        Function<ProgressIndicator, ResultsAccumulator> accumulatorSupplier = indicator -> new ResultsAccumulator(alreadyFound, (Map<? extends SearchEverywhereContributor<?>, Integer>)contributorsAndLimits, this.myEqualityProvider, this.myListener, this.myNotificationExecutor, (ProgressIndicator)indicator);
        return MultiThreadSearcher.performSearch(contributorsAndLimits.keySet(), pattern, accumulatorSupplier);
    }

    @NotNull
    private static ProgressIndicator performSearch(@NotNull Collection<? extends SearchEverywhereContributor<?>> contributors, @NotNull String pattern, @NotNull Function<ProgressIndicator, ResultsAccumulator> accumulatorSupplier) {
        ProgressIndicatorBase indicator;
        ResultsAccumulator accumulator;
        if (!contributors.isEmpty()) {
            CountDownLatch latch = new CountDownLatch(contributors.size());
            ProgressIndicatorWithCancelListener indicatorWithCancelListener = new ProgressIndicatorWithCancelListener();
            accumulator = accumulatorSupplier.apply(indicatorWithCancelListener);
            for (SearchEverywhereContributor<?> contributor : contributors) {
                Runnable task2 = MultiThreadSearcher.createSearchTask(pattern, accumulator, indicatorWithCancelListener, contributor, () -> latch.countDown());
                ApplicationManager.getApplication().executeOnPooledThread(task2);
            }
            Runnable finisherTask = MultiThreadSearcher.createFinisherTask(latch, accumulator, indicatorWithCancelListener);
            Future finisherFeature = ApplicationManager.getApplication().executeOnPooledThread(finisherTask);
            indicatorWithCancelListener.setCancelCallback(() -> {
                accumulator.stop();
                finisherFeature.cancel(true);
            });
            indicator = indicatorWithCancelListener;
        } else {
            indicator = new ProgressIndicatorBase();
            accumulator = accumulatorSupplier.apply(indicator);
        }
        indicator.start();
        if (contributors.isEmpty()) {
            indicator.stop();
            accumulator.searchFinished();
        }
        return indicator;
    }

    @NotNull
    private static Runnable createSearchTask(String pattern, ResultsAccumulator accumulator, ProgressIndicator indicator, SearchEverywhereContributor<?> contributor, Runnable finalCallback) {
        ContributorSearchTask task2 = new ContributorSearchTask(contributor, pattern, accumulator, indicator, finalCallback);
        return ConcurrencyUtil.underThreadNameRunnable((String)("SE-SearchTask-" + contributor.getSearchProviderId()), task2);
    }

    private static Runnable createFinisherTask(CountDownLatch latch, ResultsAccumulator accumulator, ProgressIndicator indicator) {
        return ConcurrencyUtil.underThreadNameRunnable((String)"SE-FinisherTask", () -> {
            try {
                latch.await();
                if (!indicator.isCanceled()) {
                    accumulator.searchFinished();
                }
                indicator.stop();
            }
            catch (InterruptedException e) {
                LOG.debug("Finisher interrupted before search process is finished");
            }
        });
    }

    private static class ProgressIndicatorWithCancelListener
    extends ProgressIndicatorBase {
        private volatile Runnable cancelCallback = () -> {};

        private ProgressIndicatorWithCancelListener() {
        }

        private void setCancelCallback(Runnable cancelCallback) {
            this.cancelCallback = cancelCallback;
        }

        @Override
        protected void onRunningChange() {
            if (this.isCanceled()) {
                this.cancelCallback.run();
            }
        }
    }

    private static class ResultsAccumulator {
        private final Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> mySections;
        private final SESearcher.Listener myListener;
        private final Executor myNotificationExecutor;
        private final SEResultsEqualityProvider myEqualityProvider;
        private final ProgressIndicator myProgressIndicator;
        private final Map<? extends SearchEverywhereContributor<?>, Integer> sectionsLimits;
        private final Map<? extends SearchEverywhereContributor<?>, Condition> conditionsMap;
        private final Map<SearchEverywhereContributor<?>, Boolean> hasMoreMap = new ConcurrentHashMap();
        private final Set<SearchEverywhereContributor<?>> finishedContributorsSet = ContainerUtil.newConcurrentSet();
        private final Lock lock = new ReentrantLock();
        private volatile boolean mySearchFinished = false;

        ResultsAccumulator(Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, SEResultsEqualityProvider equalityProvider, SESearcher.Listener listener2, Executor notificationExecutor, ProgressIndicator progressIndicator2) {
            this(contributorsAndLimits.entrySet().stream().collect(Collectors.toMap(entry -> (SearchEverywhereContributor)entry.getKey(), entry -> new ArrayList((Integer)entry.getValue()))), contributorsAndLimits, equalityProvider, listener2, notificationExecutor, progressIndicator2);
        }

        ResultsAccumulator(Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> alreadyFound, Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, SEResultsEqualityProvider equalityProvider, SESearcher.Listener listener2, Executor notificationExecutor, ProgressIndicator progressIndicator2) {
            this.mySections = alreadyFound;
            this.myEqualityProvider = equalityProvider;
            this.myListener = listener2;
            this.myNotificationExecutor = notificationExecutor;
            this.myProgressIndicator = progressIndicator2;
            this.sectionsLimits = new HashMap(contributorsAndLimits);
            this.conditionsMap = contributorsAndLimits.keySet().stream().collect(Collectors.toMap(Function.identity(), c -> this.lock.newCondition()));
        }

        public void setContributorHasMore(SearchEverywhereContributor<?> contributor, boolean hasMore) {
            this.hasMoreMap.put(contributor, hasMore);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addElement(Object element2, SearchEverywhereContributor<?> contributor, int priority, ProgressIndicator indicator) throws InterruptedException {
            SearchEverywhereFoundElementInfo newElementInfo = new SearchEverywhereFoundElementInfo(element2, priority, contributor);
            Condition condition = this.conditionsMap.get(contributor);
            Collection<SearchEverywhereFoundElementInfo> section = this.mySections.get(contributor);
            int limit = this.sectionsLimits.get(contributor);
            this.lock.lock();
            try {
                while (section.size() >= limit && !this.mySearchFinished) {
                    indicator.checkCanceled();
                    condition.await(100L, TimeUnit.MILLISECONDS);
                }
                if (this.mySearchFinished) {
                    boolean bl = false;
                    return bl;
                }
                Map<SEResultsEqualityProvider.SEEqualElementsActionType, Collection<SearchEverywhereFoundElementInfo>> otherElementsMap = this.getActionsWithOtherElements(newElementInfo);
                if (otherElementsMap.get((Object)SEResultsEqualityProvider.SEEqualElementsActionType.REPLACE).isEmpty() && !otherElementsMap.get((Object)SEResultsEqualityProvider.SEEqualElementsActionType.SKIP).isEmpty()) {
                    LOG.debug(String.format("Element %s for contributor %s was skipped", element2.toString(), contributor.getSearchProviderId()));
                    boolean bl = true;
                    return bl;
                }
                section.add(newElementInfo);
                this.runInNotificationExecutor(() -> this.myListener.elementsAdded(Collections.singletonList(newElementInfo)));
                ArrayList<SearchEverywhereFoundElementInfo> toRemove2 = new ArrayList<SearchEverywhereFoundElementInfo>(otherElementsMap.get((Object)SEResultsEqualityProvider.SEEqualElementsActionType.REPLACE));
                toRemove2.forEach(info -> {
                    Collection<SearchEverywhereFoundElementInfo> list2 = this.mySections.get(info.getContributor());
                    Condition listCondition = this.conditionsMap.get(info.getContributor());
                    list2.remove(info);
                    LOG.debug(String.format("Element %s for contributor %s is removed", info.getElement().toString(), info.getContributor().getSearchProviderId()));
                    listCondition.signal();
                });
                this.runInNotificationExecutor(() -> this.myListener.elementsRemoved(toRemove2));
                if (section.size() >= limit) {
                    this.stopSearchIfNeeded();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void contributorFinished(SearchEverywhereContributor<?> contributor) {
            this.lock.lock();
            try {
                this.finishedContributorsSet.add(contributor);
                this.stopSearchIfNeeded();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void searchFinished() {
            this.runInNotificationExecutor(() -> this.myListener.searchFinished(this.hasMoreMap));
        }

        public void stop() {
            this.lock.lock();
            try {
                this.mySearchFinished = true;
                this.conditionsMap.values().forEach(Condition::signalAll);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void stopSearchIfNeeded() {
            if (this.mySections.keySet().stream().allMatch(contributor -> this.isContributorFinished((SearchEverywhereContributor<?>)contributor))) {
                this.mySearchFinished = true;
                this.conditionsMap.values().forEach(Condition::signalAll);
            }
        }

        private boolean isContributorFinished(SearchEverywhereContributor<?> contributor) {
            if (this.finishedContributorsSet.contains(contributor)) {
                return true;
            }
            Integer limit = this.sectionsLimits.get(contributor);
            return limit == null || this.mySections.get(contributor).size() >= limit;
        }

        private Map<SEResultsEqualityProvider.SEEqualElementsActionType, Collection<SearchEverywhereFoundElementInfo>> getActionsWithOtherElements(SearchEverywhereFoundElementInfo newElement) {
            EnumMap<SEResultsEqualityProvider.SEEqualElementsActionType, Collection<SearchEverywhereFoundElementInfo>> res2 = new EnumMap<SEResultsEqualityProvider.SEEqualElementsActionType, Collection<SearchEverywhereFoundElementInfo>>(SEResultsEqualityProvider.SEEqualElementsActionType.class);
            res2.put(SEResultsEqualityProvider.SEEqualElementsActionType.REPLACE, new ArrayList());
            res2.put(SEResultsEqualityProvider.SEEqualElementsActionType.SKIP, new ArrayList());
            this.mySections.values().stream().flatMap(Collection::stream).forEach(info -> {
                SEResultsEqualityProvider.SEEqualElementsActionType action2 = this.myEqualityProvider.compareItems(newElement, (SearchEverywhereFoundElementInfo)info);
                if (action2 != SEResultsEqualityProvider.SEEqualElementsActionType.DO_NOTHING) {
                    ((Collection)res2.get((Object)action2)).add(info);
                }
            });
            return res2;
        }

        private void runInNotificationExecutor(Runnable runnable2) {
            this.myNotificationExecutor.execute(() -> {
                if (!this.myProgressIndicator.isCanceled()) {
                    runnable2.run();
                }
            });
        }
    }

    private static class ContributorSearchTask<Item>
    implements Runnable {
        private final ResultsAccumulator myAccumulator;
        private final Runnable finishCallback;
        private final SearchEverywhereContributor<Item> myContributor;
        private final String myPattern;
        private final ProgressIndicator myIndicator;

        private ContributorSearchTask(SearchEverywhereContributor<Item> contributor, String pattern, ResultsAccumulator accumulator, ProgressIndicator indicator, Runnable callback2) {
            this.myContributor = contributor;
            this.myPattern = pattern;
            this.myAccumulator = accumulator;
            this.myIndicator = indicator;
            this.finishCallback = callback2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("Search task started for contributor ", new Object[]{this.myContributor});
            try {
                SensitiveProgressWrapper wrapperIndicator;
                boolean repeat;
                do {
                    wrapperIndicator = new SensitiveProgressWrapper(this.myIndicator);
                    try {
                        Runnable runnable2 = this.myContributor instanceof WeightedSearchEverywhereContributor ? () -> ((WeightedSearchEverywhereContributor)this.myContributor).fetchWeightedElements(this.myPattern, wrapperIndicator, descriptor2 -> this.processFoundItem(descriptor2.getItem(), descriptor2.getWeight(), wrapperIndicator)) : () -> this.myContributor.fetchElements(this.myPattern, wrapperIndicator, element2 -> {
                            int priority = this.myContributor.getElementPriority(Objects.requireNonNull(element2), this.myPattern);
                            return this.processFoundItem(element2, priority, wrapperIndicator);
                        });
                        ProgressManager.getInstance().runProcess(runnable2, (ProgressIndicator)wrapperIndicator);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                } while (repeat = !this.myIndicator.isCanceled() && wrapperIndicator.isCanceled());
                if (this.myIndicator.isCanceled()) {
                    return;
                }
                this.myAccumulator.contributorFinished(this.myContributor);
            }
            finally {
                this.finishCallback.run();
            }
            LOG.debug("Search task finished for contributor ", new Object[]{this.myContributor});
        }

        private boolean processFoundItem(Item element2, int priority, ProgressIndicator wrapperIndicator) {
            try {
                if (element2 == null) {
                    LOG.debug("Skip null element");
                    return true;
                }
                boolean added = this.myAccumulator.addElement(element2, this.myContributor, priority, wrapperIndicator);
                if (!added) {
                    this.myAccumulator.setContributorHasMore(this.myContributor, true);
                }
                return added;
            }
            catch (InterruptedException e) {
                LOG.warn("Search task was interrupted");
                return false;
            }
        }
    }
}

