/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.GotoActionAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.Changeable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.OnOffButton;
import com.intellij.util.IconUtil;
import com.intellij.util.Processor;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class TopHitSEContributor
implements SearchEverywhereContributor<Object> {
    public static final int TOP_HIT_ELEMENT_PRIORITY = 15000;
    private final Collection<SearchTopHitProvider> myTopHitProviders = Arrays.asList(SearchTopHitProvider.EP_NAME.getExtensions());
    private final Project myProject;
    private final Component myContextComponent;
    private final Consumer<? super String> mySearchStringSetter;

    public TopHitSEContributor(Project project, Component component2, Consumer<? super String> setter) {
        this.myProject = project;
        this.myContextComponent = component2;
        this.mySearchStringSetter = setter;
    }

    @NotNull
    public String getSearchProviderId() {
        return TopHitSEContributor.class.getSimpleName();
    }

    @NotNull
    public String getGroupName() {
        return IdeBundle.message((String)"search.everywhere.group.name.top.hit", (Object[])new Object[0]);
    }

    public int getSortWeight() {
        return 50;
    }

    public boolean showInFindResults() {
        return false;
    }

    public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator2, @NotNull Processor<? super Object> consumer) {
        this.fill(pattern, consumer);
    }

    @NotNull
    public List<SearchEverywhereCommandInfo> getSupportedCommands() {
        ArrayList<SearchEverywhereCommandInfo> res2 = new ArrayList<SearchEverywhereCommandInfo>();
        HashSet<String> found = new HashSet<String>();
        for (SearchTopHitProvider provider : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
            String providerId;
            if (!(provider instanceof OptionsSearchTopHitProvider) || found.contains(providerId = ((OptionsSearchTopHitProvider)provider).getId())) continue;
            found.add(providerId);
            res2.add(new SearchEverywhereCommandInfo(providerId, "", (SearchEverywhereContributor)this));
        }
        return res2;
    }

    public Object getDataForItem(@NotNull Object element2, @NotNull String dataId) {
        return null;
    }

    public boolean processSelectedItem(@NotNull Object selected2, int modifiers, @NotNull String text) {
        if (selected2 instanceof BooleanOptionDescription) {
            BooleanOptionDescription option2;
            option2.setOptionState(!(option2 = (BooleanOptionDescription)selected2).isOptionEnabled());
            return false;
        }
        if (selected2 instanceof OptionsTopHitProvider) {
            this.setSearchString(SearchTopHitProvider.getTopHitAccelerator() + ((OptionsTopHitProvider)selected2).getId() + " ");
            return false;
        }
        if (TopHitSEContributor.isActionValue(selected2) || TopHitSEContributor.isSetting(selected2)) {
            GotoActionAction.openOptionOrPerformAction(selected2, "", this.myProject, this.myContextComponent);
            return true;
        }
        return false;
    }

    public int getElementPriority(@NotNull Object element2, @NotNull String searchPattern) {
        return 15000;
    }

    @NotNull
    public ListCellRenderer<? super Object> getElementsRenderer() {
        return new TopHitRenderer(this.myProject);
    }

    private void fill(@NotNull String pattern, @NotNull Processor<Object> consumer) {
        if (pattern.startsWith(SearchTopHitProvider.getTopHitAccelerator()) && !pattern.contains(" ")) {
            return;
        }
        if (this.fillActions(pattern, consumer)) {
            return;
        }
        this.fillFromExtensions(pattern, consumer);
    }

    private void fillFromExtensions(@NotNull String pattern, Processor<Object> consumer) {
        for (SearchTopHitProvider provider : this.myTopHitProviders) {
            boolean[] interrupted = new boolean[]{false};
            provider.consumeTopHits(pattern, o -> {
                interrupted[0] = !consumer.process(o);
            }, this.myProject);
            if (!interrupted[0]) continue;
            return;
        }
    }

    private boolean fillActions(String pattern, Processor<Object> consumer) {
        ActionManager actionManager = ActionManager.getInstance();
        List actions = AbbreviationManager.getInstance().findActions(pattern);
        for (String actionId : actions) {
            AnAction action2 = actionManager.getAction(actionId);
            if (action2 == null || !this.isEnabled(action2) || consumer.process((Object)action2)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnabled(AnAction action2) {
        Presentation presentation2 = action2.getTemplatePresentation();
        if (ActionUtil.isDumbMode((Project)this.myProject) && !action2.isDumbAware()) {
            return false;
        }
        return presentation2.isEnabled() && presentation2.isVisible() && !StringUtil.isEmpty((String)presentation2.getText());
    }

    private void setSearchString(String str) {
        this.mySearchStringSetter.accept(str);
    }

    private static boolean isActionValue(Object o) {
        return o instanceof AnAction;
    }

    private static boolean isSetting(Object o) {
        return o instanceof OptionDescription;
    }

    private static String getSettingText(OptionDescription value2) {
        String hit = value2.getHit();
        if (hit == null) {
            hit = value2.getOption();
        }
        if ((hit = StringUtil.unescapeXmlEntities((String)hit)).length() > 60) {
            hit = hit.substring(0, 60) + "...";
        }
        hit = hit.replace("  ", " ");
        String text = hit.trim();
        text = StringUtil.trimEnd((String)text, (String)":");
        return text;
    }

    private static class TopHitRenderer
    extends ColoredListCellRenderer<Object> {
        private final Project myProject;

        private TopHitRenderer(Project project) {
            this.myProject = project;
        }

        public Component getListCellRendererComponent(JList<?> list2, Object value2, int index, boolean selected2, boolean hasFocus) {
            Component cmp = super.getListCellRendererComponent(list2, value2, index, selected2, hasFocus);
            if (value2 instanceof BooleanOptionDescription) {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.setBackground(UIUtil.getListBackground((boolean)selected2, (boolean)true));
                OnOffButton button2 = new OnOffButton();
                button2.setSelected(((BooleanOptionDescription)value2).isOptionEnabled());
                panel2.add(cmp, "Center");
                panel2.add((Component)button2, "East");
                cmp = panel2;
            }
            return cmp;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected2, boolean hasFocus) {
            this.setPaintFocusBorder(false);
            this.setIcon(EmptyIcon.ICON_16);
            ApplicationManager.getApplication().runReadAction(() -> {
                if (TopHitSEContributor.isActionValue(value2)) {
                    AnAction anAction = (AnAction)value2;
                    Presentation templatePresentation = anAction.getTemplatePresentation();
                    Icon icon2 = templatePresentation.getIcon();
                    if (anAction instanceof ActivateToolWindowAction) {
                        String id2 = ((ActivateToolWindowAction)anAction).getToolWindowId();
                        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(id2);
                        if (toolWindow != null) {
                            icon2 = toolWindow.getIcon();
                        }
                    }
                    this.append(String.valueOf(templatePresentation.getText()));
                    if (icon2 != null && icon2.getIconWidth() <= 16 && icon2.getIconHeight() <= 16) {
                        this.setIcon(IconUtil.toSize((Icon)icon2, (int)16, (int)16));
                    }
                } else if (TopHitSEContributor.isSetting(value2)) {
                    String text = TopHitSEContributor.getSettingText((OptionDescription)value2);
                    SimpleTextAttributes attrs = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    if (value2 instanceof Changeable && ((Changeable)value2).hasChanged()) {
                        if (selected2) {
                            attrs = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                        } else {
                            SimpleTextAttributes base = SimpleTextAttributes.LINK_BOLD_ATTRIBUTES;
                            attrs = base.derive(1, base.getFgColor(), null, null);
                        }
                    }
                    this.append(text, attrs);
                } else if (value2 instanceof OptionsTopHitProvider) {
                    this.append(SearchTopHitProvider.getTopHitAccelerator() + ((OptionsTopHitProvider)value2).getId());
                } else {
                    ItemPresentation presentation2 = null;
                    if (value2 instanceof ItemPresentation) {
                        presentation2 = (ItemPresentation)value2;
                    } else if (value2 instanceof NavigationItem) {
                        presentation2 = ((NavigationItem)value2).getPresentation();
                    }
                    if (presentation2 != null) {
                        String text = presentation2.getPresentableText();
                        this.append(text == null ? value2.toString() : text);
                        Icon icon3 = presentation2.getIcon(false);
                        if (icon3 != null) {
                            this.setIcon(icon3);
                        }
                    }
                }
            });
        }
    }
}

