/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoClassSymbolConfiguration;
import com.intellij.ide.util.gotoByName.LanguageRef;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.navigation.AnonymousElementProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeUICustomization;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassSearchEverywhereContributor
extends AbstractGotoSEContributor {
    private static final Pattern ourPatternToDetectAnonymousClasses = Pattern.compile("([.\\w]+)((\\$[\\d]+)*(\\$)?)");
    private static final Pattern ourPatternToDetectMembers = Pattern.compile("(.+)(#)(.*)");
    private final PersistentSearchEverywhereContributorFilter<LanguageRef> myFilter;

    public ClassSearchEverywhereContributor(@NotNull AnActionEvent event) {
        super(event);
        this.myFilter = ClassSearchEverywhereContributor.createLanguageFilter((Project)event.getRequiredData(CommonDataKeys.PROJECT));
    }

    @NotNull
    public String getGroupName() {
        return GotoClassPresentationUpdater.getTabTitlePluralized();
    }

    @NotNull
    public String getFullGroupName() {
        return String.join((CharSequence)"/", GotoClassPresentationUpdater.getActionTitlePluralized());
    }

    @NotNull
    public String includeNonProjectItemsText() {
        return IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.items", new Object[0]);
    }

    public int getSortWeight() {
        return 100;
    }

    @NotNull
    protected FilteringGotoByModel<LanguageRef> createModel(@NotNull Project project) {
        GotoClassModel2 model = new GotoClassModel2(project);
        if (this.myFilter != null) {
            model.setFilterItems(this.myFilter.getSelectedElements());
        }
        return model;
    }

    @NotNull
    public List<AnAction> getActions(@NotNull Runnable onChanged) {
        return this.doGetActions(this.includeNonProjectItemsText(), this.myFilter, onChanged);
    }

    @Override
    @NotNull
    public String filterControlSymbols(@NotNull String pattern) {
        if (pattern.indexOf(35) != -1) {
            pattern = ClassSearchEverywhereContributor.applyPatternFilter(pattern, ourPatternToDetectMembers);
        }
        if (pattern.indexOf(36) != -1) {
            pattern = ClassSearchEverywhereContributor.applyPatternFilter(pattern, ourPatternToDetectAnonymousClasses);
        }
        return super.filterControlSymbols(pattern);
    }

    @Override
    public int getElementPriority(@NotNull Object element2, @NotNull String searchPattern) {
        return super.getElementPriority(element2, searchPattern) + 5;
    }

    @Override
    protected PsiElement preparePsi(PsiElement psiElement, int modifiers, String searchText) {
        String path = ClassSearchEverywhereContributor.pathToAnonymousClass(searchText);
        if (path != null) {
            psiElement = ClassSearchEverywhereContributor.getElement(psiElement, path);
        }
        return super.preparePsi(psiElement, modifiers, searchText);
    }

    @Override
    @Nullable
    protected Navigatable createExtendedNavigatable(final PsiElement psi, String searchText, final int modifiers) {
        Navigatable delegate;
        Navigatable res2 = super.createExtendedNavigatable(psi, searchText, modifiers);
        if (res2 != null) {
            return res2;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
        String memberName = ClassSearchEverywhereContributor.getMemberName(searchText);
        if (file2 != null && memberName != null && (delegate = ClassSearchEverywhereContributor.findMember(memberName, searchText, psi, file2)) != null) {
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    NavigationUtil.activateFileWithPsiElement(psi, AbstractGotoSEContributor.openInCurrentWindow(modifiers));
                    delegate.navigate(true);
                }

                public boolean canNavigate() {
                    return delegate.canNavigate();
                }

                public boolean canNavigateToSource() {
                    return delegate.canNavigateToSource();
                }
            };
        }
        return null;
    }

    private static String pathToAnonymousClass(String searchedText) {
        return ClassSearchEverywhereContributor.pathToAnonymousClass(ourPatternToDetectAnonymousClasses.matcher(searchedText));
    }

    @Nullable
    public static String pathToAnonymousClass(Matcher matcher) {
        String path;
        if (matcher.matches() && (path = matcher.group(2)) != null) {
            if ((path = path.trim()).endsWith("$") && path.length() >= 2) {
                path = path.substring(0, path.length() - 2);
            }
            if (!path.isEmpty()) {
                return path;
            }
        }
        return null;
    }

    private static String getMemberName(String searchedText) {
        int index = searchedText.lastIndexOf(35);
        if (index == -1) {
            return null;
        }
        String name = searchedText.substring(index + 1).trim();
        return StringUtil.isEmpty((String)name) ? null : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Navigatable findMember(String memberPattern, String fullPattern, PsiElement psiElement, VirtualFile file2) {
        PsiStructureViewFactory factory2 = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(psiElement.getLanguage());
        StructureViewBuilder builder2 = factory2 == null ? null : factory2.getStructureViewBuilder(psiElement.getContainingFile());
        FileEditor[] editors = FileEditorManager.getInstance((Project)psiElement.getProject()).getEditors(file2);
        if (builder2 == null || editors.length == 0) {
            return null;
        }
        StructureView view = builder2.createStructureView(editors[0], psiElement.getProject());
        try {
            StructureViewTreeElement element2 = ClassSearchEverywhereContributor.findElement(view.getTreeModel().getRoot(), psiElement, 4);
            if (element2 == null) {
                Navigatable navigatable = null;
                return navigatable;
            }
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)memberPattern).build();
            int max = Integer.MIN_VALUE;
            Object target2 = null;
            for (TreeElement treeElement : element2.getChildren()) {
                int degree;
                if (!(treeElement instanceof StructureViewTreeElement)) continue;
                Object value2 = ((StructureViewTreeElement)treeElement).getValue();
                if (value2 instanceof PsiElement && value2 instanceof Navigatable && fullPattern.equals(CopyReferenceAction.elementToFqn((PsiElement)value2))) {
                    Navigatable navigatable = (Navigatable)value2;
                    return navigatable;
                }
                String presentableText = treeElement.getPresentation().getPresentableText();
                if (presentableText == null || (degree = matcher.matchingDegree(presentableText)) <= max) continue;
                max = degree;
                target2 = ((StructureViewTreeElement)treeElement).getValue();
            }
            Navigatable navigatable = target2 instanceof Navigatable ? (Navigatable)target2 : null;
            return navigatable;
        }
        finally {
            Disposer.dispose((Disposable)view);
        }
    }

    @Nullable
    private static StructureViewTreeElement findElement(StructureViewTreeElement node, PsiElement element2, int hopes) {
        Object value2 = node.getValue();
        if (value2 instanceof PsiElement) {
            if (((PsiElement)value2).isEquivalentTo(element2)) {
                return node;
            }
            if (hopes != 0) {
                for (TreeElement child2 : node.getChildren()) {
                    StructureViewTreeElement e;
                    if (!(child2 instanceof StructureViewTreeElement) || (e = ClassSearchEverywhereContributor.findElement((StructureViewTreeElement)child2, element2, hopes - 1)) == null) continue;
                    return e;
                }
            }
        }
        return null;
    }

    @NotNull
    public static PsiElement getElement(@NotNull PsiElement element2, @NotNull String path) {
        String[] classes = path.split("\\$");
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (String cls : classes) {
            if (cls.isEmpty()) continue;
            try {
                indexes.add(Integer.parseInt(cls) - 1);
            }
            catch (Exception e) {
                return element2;
            }
        }
        PsiElement current2 = element2;
        Iterator iterator2 = indexes.iterator();
        while (iterator2.hasNext()) {
            int index = (Integer)iterator2.next();
            PsiElement[] anonymousClasses = ClassSearchEverywhereContributor.getAnonymousClasses(current2);
            if (index >= 0 && index < anonymousClasses.length) {
                current2 = anonymousClasses[index];
                continue;
            }
            return current2;
        }
        return current2;
    }

    private static PsiElement @NotNull [] getAnonymousClasses(@NotNull PsiElement element2) {
        for (AnonymousElementProvider provider : AnonymousElementProvider.EP_NAME.getExtensionList()) {
            PsiElement[] elements2 = provider.getAnonymousElements(element2);
            if (elements2.length <= 0) continue;
            return elements2;
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    static PersistentSearchEverywhereContributorFilter<LanguageRef> createLanguageFilter(@NotNull Project project) {
        List<LanguageRef> items = LanguageRef.forAllLanguages();
        GotoClassSymbolConfiguration persistentConfig = GotoClassSymbolConfiguration.getInstance(project);
        return new PersistentSearchEverywhereContributorFilter<LanguageRef>(items, persistentConfig, LanguageRef::getDisplayName, LanguageRef::getIcon);
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Object> {
        @NotNull
        public SearchEverywhereContributor<Object> createContributor(@NotNull AnActionEvent initEvent) {
            return new ClassSearchEverywhereContributor(initEvent);
        }
    }
}

