/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionAction;
import com.intellij.ide.actions.SetShortcutAction;
import com.intellij.ide.actions.searcheverywhere.CheckBoxSearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionSearchEverywhereContributor
implements WeightedSearchEverywhereContributor<GotoActionModel.MatchedValue> {
    private static final Logger LOG = Logger.getInstance(ActionSearchEverywhereContributor.class);
    private final Project myProject;
    private final WeakReference<Component> myContextComponent;
    private final GotoActionModel myModel;
    private final GotoActionItemProvider myProvider;
    protected boolean myDisabledActions;

    public ActionSearchEverywhereContributor(Project project, Component contextComponent, Editor editor) {
        this.myProject = project;
        this.myContextComponent = new WeakReference<Component>(contextComponent);
        this.myModel = new GotoActionModel(project, contextComponent, editor);
        this.myProvider = new GotoActionItemProvider(this.myModel);
    }

    @NotNull
    public String getGroupName() {
        return IdeBundle.message((String)"search.everywhere.group.name.actions", (Object[])new Object[0]);
    }

    @NotNull
    public String getAdvertisement() {
        ShortcutSet altEnterShortcutSet = KeymapUtil.getActiveKeymapShortcuts((String)"ShowIntentionActions");
        String altEnter = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)altEnterShortcutSet);
        return "Press " + altEnter + " to assign a shortcut";
    }

    public String includeNonProjectItemsText() {
        return IdeBundle.message((String)"checkbox.disabled.included", (Object[])new Object[0]);
    }

    public int getSortWeight() {
        return 400;
    }

    public boolean isShownInSeparateTab() {
        return true;
    }

    public void fetchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator2, @NotNull Processor<? super FoundItemDescriptor<GotoActionModel.MatchedValue>> consumer) {
        if (StringUtil.isEmptyOrSpaces((String)pattern)) {
            return;
        }
        this.myProvider.filterElements(pattern, (Processor<? super GotoActionModel.MatchedValue>)((Processor)element2 -> {
            if (progressIndicator2.isCanceled()) {
                return false;
            }
            if (!this.myDisabledActions && element2.value instanceof GotoActionModel.ActionWrapper && !((GotoActionModel.ActionWrapper)element2.value).isAvailable()) {
                return true;
            }
            if (element2 == null) {
                LOG.error("Null action has been returned from model");
                return true;
            }
            FoundItemDescriptor descriptor2 = new FoundItemDescriptor(element2, element2.getMatchingDegree());
            return consumer.process((Object)descriptor2);
        }));
    }

    @NotNull
    public List<AnAction> getActions(final @NotNull Runnable onChanged) {
        return Collections.singletonList(new CheckBoxSearchEverywhereToggleAction(this.includeNonProjectItemsText()){

            public boolean isEverywhere() {
                return ActionSearchEverywhereContributor.this.myDisabledActions;
            }

            public void setEverywhere(boolean state) {
                ActionSearchEverywhereContributor.this.myDisabledActions = state;
                onChanged.run();
            }
        });
    }

    @NotNull
    public ListCellRenderer<? super GotoActionModel.MatchedValue> getElementsRenderer() {
        return new GotoActionModel.GotoActionListCellRenderer((Function<? super OptionDescription, String>)((Function)this.myModel::getGroupName), true);
    }

    public boolean showInFindResults() {
        return false;
    }

    @NotNull
    public String getSearchProviderId() {
        return ActionSearchEverywhereContributor.class.getSimpleName();
    }

    public Object getDataForItem(@NotNull GotoActionModel.MatchedValue element2, @NotNull String dataId) {
        AnAction action2;
        if (SetShortcutAction.SELECTED_ACTION.is(dataId)) {
            return ActionSearchEverywhereContributor.getAction(element2);
        }
        if (SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.is(dataId) && (action2 = ActionSearchEverywhereContributor.getAction(element2)) != null) {
            String description = action2.getTemplatePresentation().getDescription();
            if (UISettings.getInstance().getShowInplaceCommentsInternal()) {
                String presentableId = StringUtil.notNullize((String)ActionManager.getInstance().getId(action2), (String)("class: " + action2.getClass().getName()));
                return String.format("[%s] %s", presentableId, StringUtil.notNullize((String)description));
            }
            return description;
        }
        return null;
    }

    public boolean processSelectedItem(@NotNull GotoActionModel.MatchedValue item, int modifiers, @NotNull String text) {
        if (modifiers == 8) {
            this.showAssignShortcutDialog(item);
            return true;
        }
        Object selected2 = item.value;
        if (selected2 instanceof BooleanOptionDescription) {
            BooleanOptionDescription option2 = (BooleanOptionDescription)selected2;
            if (selected2 instanceof BooleanOptionDescription.RequiresRebuild) {
                this.myModel.clearActions();
                this.myProvider.clearIntentions();
            }
            option2.setOptionState(!option2.isOptionEnabled());
            if (selected2 instanceof BooleanOptionDescription.RequiresRebuild) {
                this.myModel.rebuildActions();
            }
            return false;
        }
        GotoActionAction.openOptionOrPerformAction(selected2, text, this.myProject, (Component)this.myContextComponent.get());
        boolean inplaceChange = selected2 instanceof GotoActionModel.ActionWrapper && ((GotoActionModel.ActionWrapper)selected2).getAction() instanceof ToggleAction;
        return !inplaceChange;
    }

    @Nullable
    private static AnAction getAction(@NotNull GotoActionModel.MatchedValue element2) {
        Object value2 = element2.value;
        if (value2 instanceof GotoActionModel.ActionWrapper) {
            value2 = ((GotoActionModel.ActionWrapper)value2).getAction();
        }
        return value2 instanceof AnAction ? (AnAction)value2 : null;
    }

    private void showAssignShortcutDialog(@NotNull GotoActionModel.MatchedValue value2) {
        AnAction action2 = ActionSearchEverywhereContributor.getAction(value2);
        if (action2 == null) {
            return;
        }
        String id2 = ActionManager.getInstance().getId(action2);
        Keymap activeKeymap = Optional.ofNullable(KeymapManager.getInstance()).map(KeymapManager::getActiveKeymap).orElse(null);
        if (activeKeymap == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Window window;
            Window window2 = window = this.myProject != null ? WindowManager.getInstance().suggestParentWindow(this.myProject) : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window == null) {
                return;
            }
            KeymapPanel.addKeyboardShortcut(id2, ActionShortcutRestrictions.getInstance().getForActionId(id2), activeKeymap, (Component)window, new QuickList[0]);
        });
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<GotoActionModel.MatchedValue> {
        @NotNull
        public SearchEverywhereContributor<GotoActionModel.MatchedValue> createContributor(@NotNull AnActionEvent initEvent) {
            return new ActionSearchEverywhereContributor(initEvent.getProject(), (Component)initEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT), (Editor)initEvent.getData(CommonDataKeys.EDITOR));
        }
    }
}

