/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.runAnything.RunAnythingCache;
import com.intellij.ide.actions.runAnything.RunAnythingSearchListModel;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunAnythingUtil {
    public static final Logger LOG = Logger.getInstance(RunAnythingUtil.class);
    public static final String SHIFT_SHORTCUT_TEXT = KeymapUtil.getShortcutText((Shortcut)KeyboardShortcut.fromString((String)"SHIFT"));
    private static final Key<Collection<Pair<String, String>>> RUN_ANYTHING_WRAPPED_COMMANDS = Key.create((String)"RUN_ANYTHING_WRAPPED_COMMANDS");

    static Font getTitleFont() {
        return UIUtil.getLabelFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL));
    }

    static JComponent createTitle(@NotNull String titleText, @NotNull Color background) {
        JLabel titleLabel = new JLabel(StringUtil.capitalizeWords((String)titleText, (boolean)true));
        titleLabel.setFont(RunAnythingUtil.getTitleFont());
        titleLabel.setForeground(UIUtil.getLabelDisabledForeground());
        SeparatorComponent separatorComponent = new SeparatorComponent(titleLabel.getPreferredSize().height / 2, (Color)new JBColor((Color)Gray._220, (Color)Gray._80), null);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)titleLabel, "West");
        panel2.add((Component)separatorComponent, "Center");
        panel2.setBorder(JBUI.Borders.empty((int)3));
        titleLabel.setBorder((Border)JBUI.Borders.emptyRight((int)3));
        panel2.setBackground(background);
        return panel2;
    }

    static void jumpNextGroup(boolean forward, JBList list2) {
        int index = list2.getSelectedIndex();
        RunAnythingSearchListModel model = RunAnythingUtil.getSearchingModel(list2);
        if (model != null && index >= 0) {
            int newIndex = forward ? model.next(index) : model.prev(index);
            list2.setSelectedIndex(newIndex);
            int more = model.next(newIndex) - 1;
            if (more < newIndex) {
                more = list2.getItemsCount() - 1;
            }
            ScrollingUtil.ensureIndexIsVisible((JList)list2, (int)more, (int)(forward ? 1 : -1));
            ScrollingUtil.ensureIndexIsVisible((JList)list2, (int)newIndex, (int)(forward ? 1 : -1));
        }
    }

    @NotNull
    public static Collection<Pair<String, String>> getOrCreateWrappedCommands(@NotNull Project project) {
        ArrayList list2 = (ArrayList)project.getUserData(RUN_ANYTHING_WRAPPED_COMMANDS);
        if (list2 == null) {
            list2 = new ArrayList();
            project.putUserData(RUN_ANYTHING_WRAPPED_COMMANDS, list2);
        }
        return list2;
    }

    @NotNull
    public static Project fetchProject(@NotNull DataContext dataContext) {
        return (Project)Objects.requireNonNull(CommonDataKeys.PROJECT.getData(dataContext));
    }

    public static void executeMatched(@NotNull DataContext dataContext, @NotNull String pattern) {
        List<String> commands = RunAnythingCache.getInstance(RunAnythingUtil.fetchProject(dataContext)).getState().getCommands();
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            LOG.info("RunAnything: module hasn't been found, command will be executed in context of 'null' module.");
        }
        for (RunAnythingProvider provider : (RunAnythingProvider[])RunAnythingProvider.EP_NAME.getExtensions()) {
            Object value2 = provider.findMatchingValue(dataContext, pattern);
            if (value2 == null) continue;
            provider.execute(dataContext, value2);
            commands.remove(pattern);
            commands.add(pattern);
            break;
        }
    }

    @Nullable
    public static RunAnythingSearchListModel getSearchingModel(@NotNull JBList list2) {
        ListModel model = list2.getModel();
        return model instanceof RunAnythingSearchListModel ? (RunAnythingSearchListModel)((Object)model) : null;
    }

    public static String getAdDebugText() {
        return IdeBundle.message((String)"run.anything.ad.run.with.debug", (Object[])new Object[]{SHIFT_SHORTCUT_TEXT});
    }

    public static String getAdDeleteCommandText() {
        return IdeBundle.message((String)"run.anything.ad.command.delete", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)KeyboardShortcut.fromString((String)"shift BACK_SPACE"))});
    }

    public static String getAdContextText() {
        return IdeBundle.message((String)"run.anything.ad.run.in.context", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)KeyboardShortcut.fromString((String)"pressed ALT"))});
    }
}

