/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.Switcher;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

class SwitcherToolWindowsListRenderer
extends ColoredListCellRenderer<Object> {
    private final SpeedSearchBase mySpeedSearch;
    private final Map<ToolWindow, String> shortcuts;
    private final boolean myPinned;
    private Supplier<Boolean> myShowEdited;
    private boolean hide = false;

    SwitcherToolWindowsListRenderer(SpeedSearchBase speedSearch2, Map<ToolWindow, String> shortcuts, boolean pinned, @NotNull Supplier<Boolean> showEdited) {
        this.mySpeedSearch = speedSearch2;
        this.shortcuts = shortcuts;
        this.myPinned = pinned;
        this.myShowEdited = showEdited;
    }

    @DirtyUI
    protected void customizeCellRenderer(@NotNull JList<?> list2, Object value2, int index, boolean selected2, boolean hasFocus) {
        this.setBorder(value2 == Switcher.SwitcherPanel.RECENT_LOCATIONS ? JBUI.Borders.customLine((Color)(selected2 ? this.getBackground() : new JBColor((Color)Gray._220, (Color)Gray._80)), (int)1, (int)0, (int)0, (int)0) : JBUI.Borders.empty());
        String nameToMatch = "";
        if (value2 instanceof ToolWindow) {
            String name;
            ToolWindow tw = (ToolWindow)value2;
            this.hide = false;
            this.setPaintFocusBorder(false);
            this.setIcon(SwitcherToolWindowsListRenderer.getIcon(tw));
            nameToMatch = tw.getStripeTitle();
            String shortcut = this.shortcuts.get(tw);
            if (this.myPinned || shortcut == null) {
                name = nameToMatch;
            } else {
                this.append(shortcut, new SimpleTextAttributes(16, null));
                name = ": " + nameToMatch;
            }
            this.append(name);
        } else if (value2 == Switcher.SwitcherPanel.RECENT_LOCATIONS) {
            String label2;
            nameToMatch = label2 = Switcher.SwitcherPanel.getRecentLocationsLabel(this.myShowEdited);
            ShortcutSet shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"RecentLocations");
            this.append(label2);
            if (!this.myShowEdited.get().booleanValue()) {
                this.append(" ").append(KeymapUtil.getShortcutsText((Shortcut[])shortcuts.getShortcuts()), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
        if (this.mySpeedSearch != null && this.mySpeedSearch.isPopupActive()) {
            this.hide = this.mySpeedSearch.matchingFragments(nameToMatch) == null && !StringUtil.isEmpty((String)this.mySpeedSearch.getEnteredPrefix());
        }
    }

    protected void doPaint(Graphics2D g) {
        GraphicsConfig config2 = new GraphicsConfig((Graphics)g);
        if (this.hide) {
            g.setComposite(AlphaComposite.getInstance(3, 0.15f));
        }
        super.doPaint(g);
        config2.restore();
    }

    private static Icon getIcon(ToolWindow toolWindow) {
        Icon icon2 = toolWindow.getIcon();
        if (icon2 == null) {
            return PlatformIcons.UI_FORM_ICON;
        }
        icon2 = IconUtil.toSize((Icon)icon2, (int)JBUIScale.scale((int)16), (int)JBUIScale.scale((int)16));
        return icon2;
    }
}

