/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public abstract class SplitterAction
extends DumbAwareAction {
    abstract void actionPerformed(@NotNull EditorWindow var1);

    public void actionPerformed(@NotNull AnActionEvent event) {
        EditorWindow window = (EditorWindow)event.getData(EditorWindow.DATA_KEY);
        if (window != null) {
            this.actionPerformed(window);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        presentation2.setEnabled(this.isEnabled(event));
        presentation2.setVisible(presentation2.isEnabled() || !ActionPlaces.isPopupPlace((String)event.getPlace()));
    }

    boolean isEnabled(@NotNull AnActionEvent event) {
        EditorWindow window = (EditorWindow)event.getData(EditorWindow.DATA_KEY);
        return window != null && window.inSplitter();
    }

    public static final class UnsplitAll
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent event) {
            FileEditorManagerEx manager = UnsplitAll.getManager(event);
            if (manager != null) {
                manager.unsplitAllWindow();
            }
        }

        public void update(@NotNull AnActionEvent event) {
            FileEditorManagerEx manager = UnsplitAll.getManager(event);
            if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
                event.getPresentation().setVisible(manager != null && manager.getWindowSplitCount() > 2);
            } else {
                event.getPresentation().setEnabled(manager != null && manager.isInSplitter());
            }
        }

        private static FileEditorManagerEx getManager(@NotNull AnActionEvent event) {
            Project project = event.getProject();
            return project == null ? null : FileEditorManagerEx.getInstanceEx(project);
        }
    }

    public static final class Unsplit
    extends SplitterAction {
        @Override
        void actionPerformed(@NotNull EditorWindow window) {
            window.getManager().unsplitWindow();
        }
    }

    public static final class ChangeOrientation
    extends SplitterAction {
        @Override
        void actionPerformed(@NotNull EditorWindow window) {
            window.getManager().changeSplitterOrientation();
        }
    }

    public static abstract class Goto
    extends SplitterAction {
        abstract EditorWindow getDestination(@NotNull EditorWindow var1);

        @Override
        void actionPerformed(@NotNull EditorWindow window) {
            window.getManager().setCurrentWindow(this.getDestination(window));
        }

        public static final class Previous
        extends Goto {
            @Override
            EditorWindow getDestination(@NotNull EditorWindow window) {
                return window.getManager().getPrevWindow(window);
            }
        }

        public static final class Next
        extends Goto {
            @Override
            EditorWindow getDestination(@NotNull EditorWindow window) {
                return window.getManager().getNextWindow(window);
            }
        }
    }
}

