/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.SearchEverywhereAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.JBPopup;
import java.awt.Component;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class SetShortcutAction
extends AnAction
implements DumbAware {
    public static final DataKey<AnAction> SELECTED_ACTION = DataKey.create((String)"SelectedAction");

    public SetShortcutAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Keymap activeKeymap;
        JBPopup seDialog = SetShortcutAction.getPopup(e).orElse(null);
        if (seDialog == null) {
            return;
        }
        KeymapManager km = KeymapManager.getInstance();
        Keymap keymap2 = activeKeymap = km != null ? km.getActiveKeymap() : null;
        if (activeKeymap == null) {
            return;
        }
        AnAction action2 = (AnAction)e.getData(SELECTED_ACTION);
        Component component2 = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (action2 == null || component2 == null) {
            return;
        }
        seDialog.cancel();
        String id2 = ActionManager.getInstance().getId(action2);
        KeymapPanel.addKeyboardShortcut(id2, ActionShortcutRestrictions.getInstance().getForActionId(id2), activeKeymap, component2, new QuickList[0]);
    }

    @NotNull
    private static Optional<JBPopup> getPopup(@NotNull AnActionEvent e) {
        return Optional.ofNullable(e.getProject()).map(it -> (ConcurrentHashMap)it.getUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP)).map(it -> (JBPopup)it.get(ClientId.getCurrent()));
    }

    public void update(@NotNull AnActionEvent e) {
        Keymap activeKeymap;
        Presentation presentation2 = e.getPresentation();
        Optional<JBPopup> seDialog = SetShortcutAction.getPopup(e);
        if (!seDialog.isPresent()) {
            presentation2.setEnabled(false);
            return;
        }
        KeymapManager km = KeymapManager.getInstance();
        Keymap keymap2 = activeKeymap = km != null ? km.getActiveKeymap() : null;
        if (activeKeymap == null) {
            presentation2.setEnabled(false);
            return;
        }
        AnAction action2 = (AnAction)e.getData(SELECTED_ACTION);
        Component component2 = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        presentation2.setEnabled(action2 != null && component2 != null);
    }
}

