/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.idea.ActionsBundle;
import com.intellij.jna.JnaLoader;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.SystemProperties;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RevealFileAction
extends DumbAwareAction
implements LightEditCompatible {
    private static final Logger LOG = Logger.getInstance(RevealFileAction.class);
    public static final NotificationListener FILE_SELECTING_LISTENER = new NotificationListener.Adapter(){

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            URL url = e.getURL();
            if (url != null) {
                try {
                    RevealFileAction.openFile(new File(url.toURI()));
                }
                catch (URISyntaxException ex) {
                    LOG.warn("invalid URL: " + url, (Throwable)ex);
                }
            }
            notification.expire();
        }
    };

    public RevealFileAction() {
        this.getTemplatePresentation().setText(RevealFileAction.getActionName());
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(RevealFileAction.isSupported() && RevealFileAction.getFile(e) != null);
        e.getPresentation().setText(RevealFileAction.getActionName());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2 = RevealFileAction.getFile(e);
        if (file2 != null) {
            RevealFileAction.openFile(new File(file2.getPresentableUrl()));
        }
    }

    @Nullable
    private static VirtualFile getFile(@NotNull AnActionEvent e) {
        return RevealFileAction.findLocalFile((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE));
    }

    public static boolean isSupported() {
        return SystemInfo.isWindows || SystemInfo.isMac || SystemInfo.hasXdgOpen() || Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    public static @NlsActions.ActionText @NotNull String getActionName() {
        return SystemInfo.isMac ? ActionsBundle.message((String)"action.RevealIn.name.mac", (Object[])new Object[0]) : ActionsBundle.message((String)"action.RevealIn.name.other", (Object[])new Object[]{RevealFileAction.getFileManagerName()});
    }

    @NotNull
    public static String getFileManagerName() {
        return Holder.fileManagerName;
    }

    @Nullable
    public static VirtualFile findLocalFile(@Nullable VirtualFile file2) {
        if (file2 == null || file2.isInLocalFileSystem()) {
            return file2;
        }
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof ArchiveFileSystem && file2.getParent() == null) {
            return ((ArchiveFileSystem)fs).getLocalByEntry(file2);
        }
        return null;
    }

    public static void showDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NotNull File file2, @Nullable DialogWrapper.DoNotAskOption option2) {
        String cancel;
        String ok = RevealFileAction.getActionName();
        if (Messages.showOkCancelDialog((Project)project, (String)message, (String)title, (String)ok, (String)(cancel = IdeBundle.message((String)"action.close", (Object[])new Object[0])), (Icon)Messages.getInformationIcon(), (DialogWrapper.DoNotAskOption)option2) == 0) {
            RevealFileAction.openFile(file2);
        }
    }

    public static void openFile(@NotNull File file2) {
        if (!file2.exists()) {
            LOG.info("does not exist: " + file2);
            return;
        }
        File parent = file2.getAbsoluteFile().getParentFile();
        if (parent != null) {
            RevealFileAction.doOpen(parent, file2);
        } else {
            RevealFileAction.doOpen(file2, null);
        }
    }

    public static void openDirectory(@NotNull File directory) {
        if (!directory.isDirectory()) {
            LOG.info("not a directory: " + directory);
            return;
        }
        RevealFileAction.doOpen(directory.getAbsoluteFile(), null);
    }

    private static void doOpen(@NotNull File _dir, @Nullable File _toSelect) {
        String toSelect2;
        String dir = FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)_dir.getPath()));
        String string = toSelect2 = _toSelect != null ? FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)_toSelect.getPath())) : null;
        if (SystemInfo.isWindows) {
            RevealFileAction.spawn(toSelect2 != null ? "explorer /select,\"" + RevealFileAction.shortPath(toSelect2) + '\"' : "explorer /root,\"" + RevealFileAction.shortPath(dir) + '\"');
        } else if (SystemInfo.isMac) {
            if (toSelect2 != null) {
                RevealFileAction.spawn("open", "-R", toSelect2);
            } else {
                RevealFileAction.spawn("open", dir);
            }
        } else {
            String fmApp = Holder.fileManagerApp;
            if (fmApp != null) {
                if (fmApp.endsWith("dolphin") && toSelect2 != null) {
                    RevealFileAction.spawn(fmApp, "--select", toSelect2);
                } else {
                    RevealFileAction.spawn(fmApp, toSelect2 != null ? toSelect2 : dir);
                }
            } else if (SystemInfo.hasXdgOpen()) {
                RevealFileAction.spawn("xdg-open", dir);
            } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                LOG.debug("opening " + dir + " via Desktop API");
                ProcessIOExecutorService.INSTANCE.execute(() -> {
                    try {
                        Desktop.getDesktop().open(new File(dir));
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                });
            } else {
                Messages.showErrorDialog((String)IdeBundle.message((String)"message.this.action.isn.t.supported.on.the.current.platform", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.title.cannot.open.file", (Object[])new Object[0]));
            }
        }
    }

    private static String shortPath(String path) {
        char[] result2;
        if (path.contains("  ") && JnaLoader.isLoaded() && Kernel32.INSTANCE.GetShortPathName(path, result2 = new char[260], result2.length) <= result2.length) {
            return Native.toString((char[])result2);
        }
        return path;
    }

    private static void spawn(String ... command) {
        LOG.debug(Arrays.toString(command));
        ProcessIOExecutorService.INSTANCE.execute(() -> {
            try {
                CapturingProcessHandler.Silent handler2;
                if (SystemInfo.isWindows) {
                    assert (command.length == 1);
                    Process process2 = Runtime.getRuntime().exec(command[0]);
                    handler2 = new CapturingProcessHandler.Silent(process2, null, command[0]);
                } else {
                    handler2 = new CapturingProcessHandler.Silent(new GeneralCommandLine(command));
                }
                handler2.runProcess(10000, false).checkSuccess(LOG);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        });
    }

    private static class Holder {
        private static final String fileManagerApp = Holder.readDesktopEntryKey("Exec").map(line -> line.split(" ")[0]).filter(exec -> exec.endsWith("nautilus") || exec.endsWith("pantheon-files") || exec.endsWith("dolphin")).orElse(null);
        private static final String fileManagerName = SystemInfo.isMac ? "Finder" : (SystemInfo.isWindows ? "Explorer" : Holder.readDesktopEntryKey("Name").orElse("File Manager"));

        private Holder() {
        }

        private static Optional<String> readDesktopEntryKey(@NonNls String key) {
            String appName;
            if (SystemInfo.hasXdgMime() && (appName = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"xdg-mime", "query", "default", "inode/directory"}))) != null && appName.endsWith(".desktop")) {
                return Stream.of(Holder.getXdgDataDirectories().split(":")).map(dir -> new File((String)dir, "applications/" + appName)).filter(File::exists).findFirst().map(file2 -> Holder.readDesktopEntryKey(file2, key));
            }
            return Optional.empty();
        }

        private static String getXdgDataDirectories() {
            return StringUtil.defaultIfEmpty((String)System.getenv("XDG_DATA_HOME"), (String)(SystemProperties.getUserHome() + "/.local/share")) + ':' + StringUtil.defaultIfEmpty((String)System.getenv("XDG_DATA_DIRS"), (String)"/usr/local/share:/usr/share");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static String readDesktopEntryKey(File file2, String key) {
            LOG.debug("looking for '" + key + "' in " + file2);
            String prefix = key + '=';
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8));){
                String string = reader.lines().filter(l -> l.startsWith(prefix)).map(l -> l.substring(prefix.length())).findFirst().orElse(null);
                return string;
            }
            catch (IOException | UncheckedIOException e) {
                LOG.info("Cannot read: " + file2, (Throwable)e);
                return null;
            }
        }
    }
}

