/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import org.jetbrains.annotations.NotNull;

public class QuickChangeCodeStyleSchemeAction
extends QuickSwitchSchemeAction {
    protected void fillActions(final Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        final CodeStyleSettingsManager manager = CodeStyleSettingsManager.getInstance((Project)project);
        if (manager.getMainProjectCodeStyle() != null) {
            group.add(new AnAction(IdeBundle.messagePointer((String)"action.QuickChangeCodeStyleSchemeAction.Anonymous.text.project", (Object[])new Object[0]), () -> "", manager.USE_PER_PROJECT_SETTINGS ? AllIcons.Actions.Forward : ourNotCurrentAction){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    manager.updateSettingsTracker();
                    manager.USE_PER_PROJECT_SETTINGS = true;
                    CodeStyleSettingsManager.getInstance((Project)project).fireCodeStyleSettingsChanged(null);
                }
            });
        }
        CodeStyleScheme currentScheme = CodeStyleSchemes.getInstance().getCurrentScheme();
        for (CodeStyleScheme scheme : CodeStyleSchemesImpl.getSchemeManager().getAllSchemes()) {
            QuickChangeCodeStyleSchemeAction.addScheme(group, manager, currentScheme, scheme);
        }
    }

    private static void addScheme(DefaultActionGroup group, final CodeStyleSettingsManager manager, CodeStyleScheme currentScheme, final CodeStyleScheme scheme) {
        group.add((AnAction)new DumbAwareAction(scheme.getName(), "", scheme == currentScheme && !manager.USE_PER_PROJECT_SETTINGS ? AllIcons.Actions.Forward : ourNotCurrentAction){

            public void actionPerformed(@NotNull AnActionEvent e) {
                CodeStyleSchemes.getInstance().setCurrentScheme(scheme);
                manager.updateSettingsTracker();
                manager.USE_PER_PROJECT_SETTINGS = false;
                manager.PREFERRED_PROJECT_CODE_STYLE = scheme.getName();
                manager.fireCodeStyleSettingsChanged(null);
            }
        });
    }

    protected boolean isEnabled() {
        return !CodeStyleSchemesImpl.getSchemeManager().getAllSchemes().isEmpty();
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(e.getProject() != null);
    }
}

