/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenFileAction
extends AnAction
implements DumbAware,
LightEditCompatible {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        boolean showFiles = project != null || PlatformProjectOpenProcessor.getInstanceIfItExists() != null;
        OpenProjectFileChooserDescriptor descriptor2 = showFiles ? new ProjectOrFileChooserDescriptor() : new ProjectOnlyFileChooserDescriptor();
        VirtualFile toSelect2 = null;
        if (StringUtil.isNotEmpty((String)GeneralSettings.getInstance().getDefaultProjectDirectory())) {
            toSelect2 = VfsUtil.findFileByIoFile((File)new File(GeneralSettings.getInstance().getDefaultProjectDirectory()), (boolean)true);
        }
        descriptor2.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, toSelect2 == null && showFiles);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)(toSelect2 != null ? toSelect2 : this.getPathToSelect()), files2 -> {
            for (VirtualFile file2 : files2) {
                if (descriptor2.isFileSelectable(file2)) continue;
                String message = IdeBundle.message((String)"error.dir.contains.no.project", (Object[])new Object[]{file2.getPresentableUrl()});
                Messages.showInfoMessage((Project)project, (String)message, (String)IdeBundle.message((String)"title.cannot.open.project", (Object[])new Object[0]));
                return;
            }
            for (VirtualFile file2 : files2) {
                OpenFileAction.doOpenFile(project, file2);
            }
        });
    }

    @Nullable
    protected VirtualFile getPathToSelect() {
        return VfsUtil.getUserHomeDir();
    }

    public void update(@NotNull AnActionEvent e) {
        if (NewWelcomeScreen.isNewWelcomeScreen(e)) {
            e.getPresentation().setIcon(AllIcons.Actions.Menu_open);
        }
    }

    private static void doOpenFile(@Nullable Project project, @NotNull VirtualFile file2) {
        Path filePath = file2.toNioPath();
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            OpenFileAction.openExistingDir(filePath, project);
            return;
        }
        if ((project == null || !file2.equals(project.getProjectFile())) && OpenProjectFileChooserDescriptor.isProjectFile(file2)) {
            int answer = OpenFileAction.shouldOpenNewProject(project, file2);
            if (answer == 2) {
                return;
            }
            if (answer == 0) {
                Project openedProject = ProjectUtil.openOrImport(filePath, OpenProjectTask.withProjectToClose(project));
                if (openedProject != null) {
                    FileChooserUtil.setLastOpenedFile(openedProject, filePath);
                }
                return;
            }
        }
        LightEditUtil.markUnknownFileTypeAsPlainTextIfNeeded(project, file2);
        FileType type = FileTypeChooser.getKnownFileTypeOrAssociate(file2, project);
        if (type == null) {
            return;
        }
        if (project != null && !project.isDefault()) {
            OpenFileAction.openFile(file2, project);
        } else if (LightEdit.openFile((VirtualFile)file2)) {
            LightEditFeatureUsagesUtil.logFileOpen(LightEditFeatureUsagesUtil.OpenPlace.WelcomeScreenOpenAction);
        } else {
            PlatformProjectOpenProcessor.createTempProjectAndOpenFile(filePath, OpenProjectTask.withProjectToClose(project));
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static Project openExistingDir(@NotNull Path file2, @Nullable Project currentProject) {
        Project openedProject;
        boolean preferAttach;
        boolean canAttach = ProjectAttachProcessor.canAttachToProject();
        boolean bl = preferAttach = currentProject != null && canAttach && PlatformUtils.isDataGrip() && !ProjectUtil.isValidProjectPath(file2);
        if (preferAttach && PlatformProjectOpenProcessor.attachToProject(currentProject, file2, null)) {
            return null;
        }
        if (canAttach) {
            OpenProjectTask options2 = PlatformProjectOpenProcessor.createOptionsToOpenDotIdeaOrCreateNewIfNotExists(file2, currentProject);
            openedProject = ProjectManagerEx.getInstanceEx().openProject(file2, options2);
        } else {
            openedProject = ProjectUtil.openOrImport(file2, OpenProjectTask.withProjectToClose(currentProject));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            FileChooserUtil.setLastOpenedFile(openedProject, file2);
        }
        return openedProject;
    }

    @Messages.YesNoCancelResult
    private static int shouldOpenNewProject(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2.getFileType() instanceof ProjectFileType) {
            return 0;
        }
        ProjectOpenProcessor provider = ProjectOpenProcessor.getImportProvider((VirtualFile)file2);
        if (provider == null) {
            return 2;
        }
        return provider.askConfirmationForOpeningProject(file2, project);
    }

    public static void openFile(String filePath, @NotNull Project project) {
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath);
        if (file2 != null && file2.isValid()) {
            OpenFileAction.openFile(file2, project);
        }
    }

    public static void openFile(VirtualFile file2, @NotNull Project project) {
        NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(file2));
        if (LightEdit.owns((Project)project)) {
            if (LightEditService.getInstance().openFile(file2, true)) {
                LightEditFeatureUsagesUtil.logFileOpen(LightEditFeatureUsagesUtil.OpenPlace.LightEditOpenAction);
            }
        } else {
            PsiNavigationSupport.getInstance().createNavigatable(project, file2, -1).navigate(true);
        }
    }

    private static class ProjectOrFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        private final FileChooserDescriptor myStandardDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withHideIgnored(false);

        ProjectOrFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.file.or.project", (Object[])new Object[0]));
        }

        @Override
        public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
            return file2.isDirectory() ? super.isFileVisible(file2, showHiddenFiles) : this.myStandardDescriptor.isFileVisible(file2, showHiddenFiles);
        }

        @Override
        public boolean isFileSelectable(VirtualFile file2) {
            return file2.isDirectory() ? super.isFileSelectable(file2) : this.myStandardDescriptor.isFileSelectable(file2);
        }

        public boolean isChooseMultiple() {
            return true;
        }
    }

    private static class ProjectOnlyFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        ProjectOnlyFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.project", (Object[])new Object[0]));
        }
    }

    public static class OnWelcomeScreen
    extends OpenFileAction {
        @Override
        public void update(@NotNull AnActionEvent e) {
            Presentation presentation2 = e.getPresentation();
            if (!NewWelcomeScreen.isNewWelcomeScreen(e)) {
                presentation2.setEnabledAndVisible(false);
                return;
            }
            if (Registry.is((String)"use.tabbed.welcome.screen")) {
                presentation2.setIcon(AllIcons.Welcome.Open);
                presentation2.setSelectedIcon(AllIcons.Welcome.OpenSelected);
                presentation2.setText(ActionsBundle.message((String)"action.Tabbed.WelcomeScreen.OpenProject.text", (Object[])new Object[0]));
            } else {
                presentation2.setIcon(AllIcons.Actions.Menu_open);
            }
        }
    }
}

