/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OccurenceNavigatorActionBase
extends AnAction
implements DumbAware {
    OccurenceNavigatorActionBase() {
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        OccurenceNavigator navigator = this.getNavigator(e.getDataContext());
        if (navigator == null || !this.hasOccurenceToGo(navigator)) {
            return;
        }
        OccurenceNavigator.OccurenceInfo occurenceInfo = this.go(navigator);
        if (occurenceInfo == null) {
            return;
        }
        Navigatable descriptor2 = occurenceInfo.getNavigateable();
        if (descriptor2 != null && descriptor2.canNavigate()) {
            descriptor2.navigate(true);
        }
        if (occurenceInfo.getOccurenceNumber() == -1 || occurenceInfo.getOccurencesCount() == -1) {
            return;
        }
        WindowManager.getInstance().getStatusBar(project).setInfo(IdeBundle.message((String)"message.occurrence.N.of.M", (Object[])new Object[]{occurenceInfo.getOccurenceNumber(), occurenceInfo.getOccurencesCount()}));
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation2.setEnabled(false);
            presentation2.setVisible(!ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()));
            return;
        }
        OccurenceNavigator navigator = this.getNavigator(event.getDataContext());
        if (navigator == null) {
            presentation2.setEnabled(false);
            presentation2.setVisible(!ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()));
            return;
        }
        presentation2.setVisible(true);
        try {
            presentation2.setEnabled(this.hasOccurenceToGo(navigator));
            presentation2.setText(this.getDescription(navigator));
        }
        catch (IndexNotReadyException e) {
            presentation2.setEnabled(false);
        }
    }

    protected abstract OccurenceNavigator.OccurenceInfo go(OccurenceNavigator var1);

    protected abstract boolean hasOccurenceToGo(OccurenceNavigator var1);

    protected abstract String getDescription(OccurenceNavigator var1);

    @Nullable
    protected OccurenceNavigator getNavigator(DataContext dataContext) {
        ContentManager contentManager2 = ContentManagerUtil.getContentManagerFromContext(dataContext, false);
        if (contentManager2 != null) {
            OccurenceNavigator navigator;
            Content content2 = contentManager2.getSelectedContent();
            OccurenceNavigator occurenceNavigator = navigator = content2 != null ? OccurenceNavigatorActionBase.findNavigator(content2.getComponent()) : null;
            if (navigator != null) {
                return navigator;
            }
        }
        return (OccurenceNavigator)OccurenceNavigatorActionBase.getOccurenceNavigatorFromContext(dataContext);
    }

    @Nullable
    private static OccurenceNavigator findNavigator(JComponent parent) {
        LinkedList<JComponent> queue = new LinkedList<JComponent>();
        queue.addLast(parent);
        while (!queue.isEmpty()) {
            JComponent component2 = (JComponent)queue.removeFirst();
            if (component2 instanceof OccurenceNavigator) {
                return (OccurenceNavigator)component2;
            }
            if (component2 instanceof JTabbedPane) {
                JComponent selectedComponent = (JComponent)((JTabbedPane)component2).getSelectedComponent();
                if (selectedComponent == null) continue;
                queue.addLast(selectedComponent);
                continue;
            }
            if (component2 == null) continue;
            for (int i2 = 0; i2 < component2.getComponentCount(); ++i2) {
                Component child2 = component2.getComponent(i2);
                if (!(child2 instanceof JComponent)) continue;
                queue.addLast((JComponent)child2);
            }
        }
        return null;
    }

    @Nullable
    private static Component getOccurenceNavigatorFromContext(DataContext dataContext) {
        Project project;
        Window window = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (window != null) {
            Component component3;
            for (Component c = component3 = window.getFocusOwner(); c != null; c = c.getParent()) {
                if (!(c instanceof OccurenceNavigator)) continue;
                return c;
            }
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return null;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getLastActiveToolWindow(component2 -> OccurenceNavigatorActionBase.findNavigator(component2) != null);
        return toolWindow == null ? null : (Component)OccurenceNavigatorActionBase.findNavigator(toolWindow.getComponent());
    }
}

