/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorTextField;
import com.intellij.util.LineSeparator;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH$J\b\u0010\t\u001a\u00020\nH$J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/actions/EditCustomSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "file", "Ljava/io/File;", "template", "", "update", "intellij.platform.ide.impl"})
public abstract class EditCustomSettingsAction
extends DumbAwareAction {
    @Nullable
    protected abstract File file();

    @NotNull
    protected abstract String template();

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled((e.getProject() != null || WelcomeFrame.getInstance() != null) && this.file() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        JFrame frame = (JFrame)WelcomeFrame.getInstance();
        File file2 = this.file();
        if (file2 == null) {
            return;
        }
        File file3 = file2;
        if (project != null) {
            VirtualFile vFile;
            if (!file3.exists()) {
                int result2;
                String confirmation = IdeBundle.message((String)"edit.custom.settings.confirm", (Object[])new Object[]{FileUtil.getLocationRelativeToUserHome((String)file3.getPath())});
                String string = e.getPresentation().getText();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((result2 = MessageUtil.showOkCancelDialog$default((String)string, (String)confirmation, (String)IdeBundle.message((String)"button.create", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), null, (Project)project, (int)32, null)) == 2) {
                    return;
                }
                try {
                    FileUtil.writeToFile((File)file3, (String)StringUtil.convertLineSeparators((String)this.template(), (String)LineSeparator.getSystemLineSeparator().getSeparatorString()));
                }
                catch (IOException ex) {
                    Logger.getInstance(((Object)((Object)this)).getClass()).warn(file3.getPath(), (Throwable)ex);
                    String message = IdeBundle.message((String)"edit.custom.settings.failed", (Object[])new Object[]{file3, ex.getMessage()});
                    Messages.showErrorDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle());
                    return;
                }
            }
            if ((vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file3)) != null) {
                vFile.refresh(false, false);
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
                if (psiFile != null) {
                    PsiNavigationSupport.getInstance().createNavigatable(project, vFile, psiFile.getTextLength()).navigate(true);
                }
            }
        } else if (frame != null) {
            String text = StringUtil.convertLineSeparators((String)(file3.exists() ? FileUtil.loadFile((File)file3) : this.template()));
            new DialogWrapper(file3, text, frame, frame, true){
                private final EditorTextField editor;
                final /* synthetic */ File $file;
                final /* synthetic */ String $text;
                final /* synthetic */ JFrame $frame;

                @NotNull
                protected EditorTextField createCenterPanel() {
                    return this.editor;
                }

                @NotNull
                public EditorTextField getPreferredFocusedComponent() {
                    return this.editor;
                }

                @NotNull
                protected String getDimensionServiceKey() {
                    return "ide.config.custom.settings";
                }

                protected void doOKAction() {
                    String toSave = StringUtil.convertLineSeparators((String)this.editor.getText(), (String)LineSeparator.getSystemLineSeparator().getSeparatorString());
                    try {
                        FileUtil.writeToFile((File)this.$file, (String)toSave);
                        this.close(0);
                    }
                    catch (IOException ex) {
                        Logger.getInstance(((Object)((Object)this)).getClass()).warn(this.$file.getPath(), (Throwable)ex);
                        String message = IdeBundle.message((String)"edit.custom.settings.failed", (Object[])new Object[]{this.$file, ex.getMessage()});
                        Messages.showErrorDialog((Component)this.getWindow(), (String)message, (String)CommonBundle.getErrorTitle());
                    }
                }
                {
                    this.$file = $captured_local_variable$0;
                    this.$text = $captured_local_variable$1;
                    this.$frame = $captured_local_variable$2;
                    super($super_call_param$3, $super_call_param$4);
                    this.setTitle(FileUtil.getLocationRelativeToUserHome((String)$captured_local_variable$0.getPath()));
                    this.setOKButtonText(IdeBundle.message((String)"button.save", (Object[])new Object[0]));
                    Document document = EditorFactory.getInstance().createDocument((CharSequence)$captured_local_variable$1);
                    Project defaultProject = DefaultProjectFactory.getInstance().getDefaultProject();
                    FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName($captured_local_variable$0.getName());
                    this.editor = new EditorTextField(document, defaultProject, fileType, document, defaultProject, fileType, false, false){
                        final /* synthetic */ Document $document;
                        final /* synthetic */ Project $defaultProject;
                        final /* synthetic */ FileType $fileType;

                        @NotNull
                        protected EditorEx createEditor() {
                            EditorEx editor = super.createEditor();
                            editor.getScrollPane().setVerticalScrollBarPolicy(20);
                            editor.getScrollPane().setHorizontalScrollBarPolicy(30);
                            return editor;
                        }
                        {
                            this.$document = $captured_local_variable$0;
                            this.$defaultProject = $captured_local_variable$1;
                            this.$fileType = $captured_local_variable$2;
                            super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
                        }
                    };
                    this.init();
                }
            }.show();
        }
    }
}

