/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import org.jetbrains.annotations.NotNull;

public abstract class BaseToolWindowToggleAction
extends ToggleAction
implements DumbAware {
    public final boolean isSelected(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return false;
        }
        ToolWindowManager mgr = ToolWindowManager.getInstance((Project)project);
        String id2 = mgr.getActiveToolWindowId();
        if (id2 == null) {
            return false;
        }
        return this.isSelected(mgr.getToolWindow(id2));
    }

    protected abstract boolean isSelected(ToolWindow var1);

    public final void setSelected(@NotNull AnActionEvent e, boolean state) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        String id2 = toolWindowManager.getActiveToolWindowId();
        if (id2 == null) {
            return;
        }
        this.setSelected(toolWindowManager.getToolWindow(id2), state);
    }

    protected abstract void setSelected(ToolWindow var1, boolean var2);

    public final void update(@NotNull AnActionEvent e) {
        super.update(e);
        Presentation presentation2 = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation2.setEnabled(false);
            return;
        }
        ToolWindowManager mgr = ToolWindowManager.getInstance((Project)project);
        String id2 = mgr.getActiveToolWindowId();
        if (id2 == null) {
            presentation2.setEnabled(false);
            return;
        }
        ToolWindow window = mgr.getToolWindow(id2);
        if (window == null) {
            presentation2.setEnabled(false);
            return;
        }
        this.update(window, presentation2);
    }

    protected abstract void update(ToolWindow var1, Presentation var2);
}

