/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.AppTopics;
import com.intellij.ProjectTopics;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class GeneratedSourceFileChangeTrackerImpl
extends GeneratedSourceFileChangeTracker {
    private final Project myProject;
    private final SingleAlarm myCheckingQueue;
    private final Set<VirtualFile> myFilesToCheck = Collections.synchronizedSet(new HashSet());
    private final Set<VirtualFile> myEditedGeneratedFiles = Collections.synchronizedSet(new HashSet());
    public static boolean IN_TRACKER_TEST;

    public GeneratedSourceFileChangeTrackerImpl(@NotNull Project project) {
        this.myProject = project;
        this.myCheckingQueue = new SingleAlarm(this::checkFiles, 500, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
    }

    void waitForAlarm(long timeout, @NotNull TimeUnit timeUnit) throws Exception {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not wait for the alarm under write action");
        }
        this.myCheckingQueue.waitForAllExecuted(timeout, timeUnit);
    }

    public void cancelAllAndWait(long timeout, @NotNull TimeUnit timeUnit) throws Exception {
        this.myFilesToCheck.clear();
        this.myCheckingQueue.cancelAllRequests();
        this.waitForAlarm(timeout, timeUnit);
    }

    @Override
    public boolean isEditedGeneratedFile(@NotNull VirtualFile file2) {
        return this.myEditedGeneratedFiles.contains(file2);
    }

    private static boolean isListenerInactive() {
        return !IN_TRACKER_TEST && ApplicationManager.getApplication().isUnitTestMode();
    }

    private void projectOpened() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                GeneratedSourceFileChangeTrackerImpl.this.myFilesToCheck.remove(file2);
                if (GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.remove(file2)) {
                    EditorNotifications.getInstance((Project)GeneratedSourceFileChangeTrackerImpl.this.myProject).updateNotifications(file2);
                }
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.remove(file2);
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                GeneratedSourceFileChangeTrackerImpl.this.myFilesToCheck.addAll(GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles);
                GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.clear();
                GeneratedSourceFileChangeTrackerImpl.this.myCheckingQueue.cancelAndRequest();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFiles() {
        VirtualFile[] files2;
        Set<VirtualFile> set = this.myFilesToCheck;
        synchronized (set) {
            files2 = this.myFilesToCheck.toArray(VirtualFile.EMPTY_ARRAY);
            this.myFilesToCheck.clear();
        }
        if (files2.length == 0) {
            return;
        }
        ArrayList newEditedGeneratedFiles = new ArrayList();
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (VirtualFile file2 : files2) {
                if (!GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)this.myProject)) continue;
                newEditedGeneratedFiles.add(file2);
            }
        });
        if (!newEditedGeneratedFiles.isEmpty()) {
            this.myEditedGeneratedFiles.addAll(newEditedGeneratedFiles);
            EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        }
    }

    static final class MyProjectManagerListener
    implements ProjectManagerListener {
        MyProjectManagerListener() {
        }

        public void projectOpened(@NotNull Project project) {
            if (GeneratedSourceFileChangeTrackerImpl.isListenerInactive()) {
                return;
            }
            ((GeneratedSourceFileChangeTrackerImpl)GeneratedSourceFileChangeTracker.getInstance(project)).projectOpened();
        }
    }

    static final class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            if (GeneratedSourceFileChangeTrackerImpl.isListenerInactive()) {
                return;
            }
            Project[] openProjects = ProjectUtil.getOpenProjects();
            if (openProjects.length == 0) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(event.getDocument());
            if (file2 == null) {
                return;
            }
            for (Project project : ProjectUtil.getOpenProjects()) {
                if (project.isDisposed()) continue;
                GeneratedSourceFileChangeTrackerImpl fileChangeTracker = (GeneratedSourceFileChangeTrackerImpl)GeneratedSourceFileChangeTracker.getInstance(project);
                ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
                if (!fileIndex.isInContent(file2) && !fileIndex.isInLibrary(file2)) continue;
                fileChangeTracker.myFilesToCheck.add(file2);
                fileChangeTracker.myCheckingQueue.cancelAndRequest();
            }
        }
    }
}

