/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ClipboardSynchronizer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretStateTransferableData;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ide.CutElementMarker;
import com.intellij.openapi.ide.KillRingTransferable;
import com.intellij.openapi.ide.Sizeable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.LinkedListWithSum;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyPasteManagerEx
extends CopyPasteManager
implements ClipboardOwner {
    private static final Logger LOG = Logger.getInstance(CopyPasteManagerEx.class);
    private final LinkedListWithSum<Transferable> myData = new LinkedListWithSum(CopyPasteManagerEx::getSize);
    private final EventDispatcher<CopyPasteManager.ContentChangedListener> myDispatcher = EventDispatcher.create(CopyPasteManager.ContentChangedListener.class);
    private boolean myOwnContent;

    public static CopyPasteManagerEx getInstanceEx() {
        return (CopyPasteManagerEx)CopyPasteManagerEx.getInstance();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.myOwnContent = false;
        ClipboardSynchronizer.getInstance().resetContent();
        this.fireContentChanged(contents, null);
    }

    private void fireContentChanged(@Nullable Transferable oldContent, @Nullable Transferable newContent) {
        ((CopyPasteManager.ContentChangedListener)this.myDispatcher.getMulticaster()).contentChanged(oldContent, newContent);
    }

    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2, @NotNull Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
        return flavors.length > 0 && ClipboardSynchronizer.getInstance().areDataFlavorsAvailable(flavors);
    }

    public void setContents(@NotNull Transferable content2) {
        Transferable oldContent = this.myOwnContent && !this.myData.isEmpty() ? (Transferable)this.myData.get(0) : null;
        Transferable contentToUse = this.addNewContentToStack(content2);
        this.setSystemClipboardContent(contentToUse);
        this.fireContentChanged(oldContent, contentToUse);
    }

    public boolean isCutElement(@Nullable Object element2) {
        for (CutElementMarker marker : CutElementMarker.EP_NAME.getExtensionList()) {
            if (!marker.isCutElement(element2)) continue;
            return true;
        }
        return false;
    }

    public void stopKillRings() {
        for (Transferable data2 : this.myData) {
            if (!(data2 instanceof KillRingTransferable)) continue;
            ((KillRingTransferable)data2).setReadyToCombine(false);
        }
    }

    private void setSystemClipboardContent(Transferable content2) {
        ClipboardSynchronizer.getInstance().setContent(content2, this);
        this.myOwnContent = true;
    }

    @NotNull
    private Transferable addNewContentToStack(@NotNull Transferable content2) {
        try {
            String clipString = CopyPasteManagerEx.getStringContent(content2);
            if (clipString == null) {
                return content2;
            }
            if (content2 instanceof KillRingTransferable) {
                Transferable merged;
                Transferable prev;
                KillRingTransferable killRingContent = (KillRingTransferable)content2;
                if (killRingContent.isReadyToCombine() && !this.myData.isEmpty() && (prev = (Transferable)this.myData.get(0)) instanceof KillRingTransferable && (merged = CopyPasteManagerEx.merge(killRingContent, (KillRingTransferable)prev)) != null) {
                    this.myData.set(0, (Object)merged);
                    return merged;
                }
                if (killRingContent.isReadyToCombine()) {
                    this.addToTheTopOfTheStack((Transferable)killRingContent);
                    return killRingContent;
                }
            }
            CaretStateTransferableData caretData = CaretStateTransferableData.getFrom(content2);
            Iterator it = this.myData.iterator();
            while (it.hasNext()) {
                Transferable old = (Transferable)it.next();
                if (!clipString.equals(CopyPasteManagerEx.getStringContent(old)) || !CaretStateTransferableData.areEquivalent(caretData, CaretStateTransferableData.getFrom(old))) continue;
                it.remove();
                this.myData.add(0, (Object)content2);
                return content2;
            }
            this.addToTheTopOfTheStack(content2);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        return content2;
    }

    private void addToTheTopOfTheStack(@NotNull Transferable content2) {
        this.myData.add(0, (Object)content2);
        this.deleteAfterAllowedMaximum();
    }

    @Nullable
    private static Transferable merge(@NotNull KillRingTransferable newData, @NotNull KillRingTransferable oldData) throws IOException, UnsupportedFlavorException {
        if (!oldData.isReadyToCombine() || !newData.isReadyToCombine()) {
            return null;
        }
        Document document = newData.getDocument();
        if (document == null || document != oldData.getDocument()) {
            return null;
        }
        Object newDataText = newData.getTransferData(DataFlavor.stringFlavor);
        Object oldDataText = oldData.getTransferData(DataFlavor.stringFlavor);
        if (newDataText == null || oldDataText == null) {
            return null;
        }
        if (oldData.isCut() && newData.getStartOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(oldDataText.toString() + newDataText, document, oldData.getStartOffset(), newData.getEndOffset(), newData.isCut());
        }
        if (newData.getStartOffset() == oldData.getEndOffset()) {
            return new KillRingTransferable(oldDataText.toString() + newDataText, document, oldData.getStartOffset(), newData.getEndOffset(), false);
        }
        if (newData.getEndOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(newDataText.toString() + oldDataText, document, newData.getStartOffset(), oldData.getEndOffset(), false);
        }
        return null;
    }

    private static String getStringContent(@NotNull Transferable content2) {
        try {
            return (String)content2.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return null;
        }
    }

    private void deleteAfterAllowedMaximum() {
        int maxCount = Math.max(1, Registry.intValue((String)"clipboard.history.max.items"));
        int maxMemory = Math.max(0, Registry.intValue((String)"clipboard.history.max.memory"));
        int smallItemSizeLimit = maxMemory / maxCount / 10;
        if (this.myData.size() > maxCount) {
            this.myData.subList(maxCount, this.myData.size()).clear();
        }
        LinkedListWithSum.ListIterator it = this.myData.listIterator(this.myData.size());
        while (this.myData.getSum() > (long)maxMemory && it.hasPrevious() && it.previousIndex() > 0) {
            it.previous();
            if (it.getValue() <= smallItemSizeLimit) continue;
            it.set((Object)CopyPasteManagerEx.createPurgedItem());
        }
    }

    public Transferable getContents() {
        return ClipboardSynchronizer.getInstance().getContents();
    }

    @Nullable
    public <T> T getContents(@NotNull DataFlavor flavor) {
        if (this.areDataFlavorsAvailable(flavor)) {
            return (T)ClipboardSynchronizer.getInstance().getData(flavor);
        }
        return null;
    }

    public Transferable @NotNull [] getAllContents() {
        String clipString = (String)this.getContents(DataFlavor.stringFlavor);
        if (clipString != null && (this.myData.isEmpty() || !Objects.equals(clipString, CopyPasteManagerEx.getStringContent((Transferable)this.myData.get(0))))) {
            this.addToTheTopOfTheStack(new StringSelection(clipString));
        }
        return (Transferable[])this.myData.toArray((Object[])new Transferable[0]);
    }

    public void removeContent(Transferable t) {
        Transferable current2 = this.myData.isEmpty() ? null : (Transferable)this.myData.get(0);
        this.myData.remove((Object)t);
        if (Comparing.equal((Object)t, (Object)current2)) {
            Transferable newContent = !this.myData.isEmpty() ? (Transferable)this.myData.get(0) : new StringSelection("");
            this.setSystemClipboardContent(newContent);
            this.fireContentChanged(current2, newContent);
        }
    }

    public void moveContentToStackTop(Transferable t) {
        Transferable current2;
        Transferable transferable = current2 = this.myData.isEmpty() ? null : (Transferable)this.myData.get(0);
        if (!Comparing.equal((Object)t, (Object)current2)) {
            this.myData.remove((Object)t);
            this.myData.add(0, (Object)t);
            this.setSystemClipboardContent(t);
            this.fireContentChanged(current2, t);
        } else {
            this.setSystemClipboardContent(t);
        }
    }

    private static Transferable createPurgedItem() {
        return new StringSelection(UIBundle.message((String)"clipboard.history.purged.item", (Object[])new Object[0]));
    }

    private static int getSize(Transferable t) {
        if (t instanceof StringSelection) {
            try {
                return StringUtil.length((CharSequence)((String)t.getTransferData(DataFlavor.stringFlavor)));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        } else if (t instanceof Sizeable) {
            int size = ((Sizeable)t).getSize();
            if (size >= 0) {
                return size;
            }
            LOG.error("Got negative size (" + size + ") from " + t);
        }
        return 1000;
    }
}

